% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafregional_operations.R
\name{wafregional_get_sampled_requests}
\alias{wafregional_get_sampled_requests}
\title{This is AWS WAF Classic documentation}
\usage{
wafregional_get_sampled_requests(WebAclId, RuleId, TimeWindow, MaxItems)
}
\arguments{
\item{WebAclId}{[required] The \code{WebACLId} of the \code{WebACL} for which you want
\code{\link[=wafregional_get_sampled_requests]{get_sampled_requests}} to return a
sample of requests.}

\item{RuleId}{[required] \code{RuleId} is one of three values:
\itemize{
\item The \code{RuleId} of the \code{Rule} or the \code{RuleGroupId} of the \code{RuleGroup}
for which you want
\code{\link[=wafregional_get_sampled_requests]{get_sampled_requests}} to return
a sample of requests.
\item \code{Default_Action}, which causes
\code{\link[=wafregional_get_sampled_requests]{get_sampled_requests}} to return
a sample of the requests that didn't match any of the rules in the
specified \code{WebACL}.
}}

\item{TimeWindow}{[required] The start date and time and the end date and time of the range for which
you want \code{\link[=wafregional_get_sampled_requests]{get_sampled_requests}} to
return a sample of requests. You must specify the times in Coordinated
Universal Time (UTC) format. UTC format includes the special designator,
\code{Z}. For example, \code{"2016-09-27T14:50Z"}. You can specify any time range
in the previous three hours.}

\item{MaxItems}{[required] The number of requests that you want AWS WAF to return from among the
first 5,000 requests that your AWS resource received during the time
range. If your resource received fewer requests than the value of
\code{MaxItems}, \code{\link[=wafregional_get_sampled_requests]{get_sampled_requests}}
returns information about all of them.}
}
\description{
This is \strong{AWS WAF Classic} documentation. For more information, see \href{https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html}{AWS WAF Classic} in the developer guide.

See \url{https://paws-r.github.io/docs/wafregional/get_sampled_requests.html} for full documentation.
}
\keyword{internal}
