% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/accessanalyzer_operations.R
\name{accessanalyzer_validate_policy}
\alias{accessanalyzer_validate_policy}
\title{Requests the validation of a policy and returns a list of findings}
\usage{
accessanalyzer_validate_policy(
  locale = NULL,
  maxResults = NULL,
  nextToken = NULL,
  policyDocument,
  policyType,
  validatePolicyResourceType = NULL
)
}
\arguments{
\item{locale}{The locale to use for localizing the findings.}

\item{maxResults}{The maximum number of results to return in the response.}

\item{nextToken}{A token used for pagination of results returned.}

\item{policyDocument}{[required] The JSON policy document to use as the content for the policy.}

\item{policyType}{[required] The type of policy to validate. Identity policies grant permissions to
IAM principals. Identity policies include managed and inline policies
for IAM roles, users, and groups. They also include service-control
policies (SCPs) that are attached to an Amazon Web Services
organization, organizational unit (OU), or an account.

Resource policies grant permissions on Amazon Web Services resources.
Resource policies include trust policies for IAM roles and bucket
policies for Amazon S3 buckets. You can provide a generic input such as
identity policy or resource policy or a specific input such as managed
policy or Amazon S3 bucket policy.}

\item{validatePolicyResourceType}{The type of resource to attach to your resource policy. Specify a value
for the policy validation resource type only if the policy type is
\code{RESOURCE_POLICY}. For example, to validate a resource policy to attach
to an Amazon S3 bucket, you can choose \verb{AWS::S3::Bucket} for the policy
validation resource type.

For resource types not supported as valid values, IAM Access Analyzer
runs policy checks that apply to all resource policies. For example, to
validate a resource policy to attach to a KMS key, do not specify a
value for the policy validation resource type and IAM Access Analyzer
will run policy checks that apply to all resource policies.}
}
\description{
Requests the validation of a policy and returns a list of findings. The findings help you identify issues and provide actionable recommendations to resolve the issue and enable you to author functional policies that meet security best practices.

See \url{https://www.paws-r-sdk.com/docs/accessanalyzer_validate_policy/} for full documentation.
}
\keyword{internal}
