% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_describe_managed_rule_group}
\alias{wafv2_describe_managed_rule_group}
\title{Provides high-level information for a managed rule group, including
descriptions of the rules}
\usage{
wafv2_describe_managed_rule_group(VendorName, Name, Scope, VersionName = NULL)
}
\arguments{
\item{VendorName}{[required] The name of the managed rule group vendor. You use this, along with the
rule group name, to identify a rule group.}

\item{Name}{[required] The name of the managed rule group. You use this, along with the vendor
name, to identify the rule group.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{VersionName}{The version of the rule group. You can only use a version that is not
scheduled for expiration. If you don't provide this, WAF uses the
vendor's default version.}
}
\description{
Provides high-level information for a managed rule group, including descriptions of the rules.

See \url{https://www.paws-r-sdk.com/docs/wafv2_describe_managed_rule_group/} for full documentation.
}
\keyword{internal}
