% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/account_operations.R
\name{account_enable_region}
\alias{account_enable_region}
\title{Enables (opts-in) a particular Region for an account}
\usage{
account_enable_region(AccountId = NULL, RegionName)
}
\arguments{
\item{AccountId}{Specifies the 12-digit account ID number of the Amazon Web Services
account that you want to access or modify with this operation. If you
don't specify this parameter, it defaults to the Amazon Web Services
account of the identity used to call the operation. To use this
parameter, the caller must be an identity in the \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_getting-started_concepts.html#account}{organization's management account}
or a delegated administrator account. The specified account ID must be a
member account in the same organization. The organization must have \href{https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_org_support-all-features.html}{all features enabled},
and the organization must have \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{trusted access}
enabled for the Account Management service, and optionally a \href{https://docs.aws.amazon.com/organizations/latest/userguide/}{delegated admin}
account assigned.

The management account can't specify its own \code{AccountId}. It must call
the operation in standalone context by not including the \code{AccountId}
parameter.

To call this operation on an account that is not a member of an
organization, don't specify this parameter. Instead, call the operation
using an identity belonging to the account whose contacts you wish to
retrieve or modify.}

\item{RegionName}{[required] Specifies the Region-code for a given Region name (for example,
\code{af-south-1}). When you enable a Region, Amazon Web Services performs
actions to prepare your account in that Region, such as distributing
your IAM resources to the Region. This process takes a few minutes for
most accounts, but it can take several hours. You cannot use the Region
until this process is complete. Furthermore, you cannot disable the
Region until the enabling process is fully completed.}
}
\description{
Enables (opts-in) a particular Region for an account.

See \url{https://www.paws-r-sdk.com/docs/account_enable_region/} for full documentation.
}
\keyword{internal}
