% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaconnectorad_service.R
\name{pcaconnectorad}
\alias{pcaconnectorad}
\title{PcaConnectorAd}
\usage{
pcaconnectorad(
  config = list(),
  credentials = list(),
  endpoint = NULL,
  region = NULL
)
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{credentials}: \itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}
\item{\strong{endpoint}: The complete URL to use for the constructed client.}
\item{\strong{region}: The AWS Region used in instantiating the client.}
\item{\strong{close_connection}: Immediately close all HTTP connections.}
\item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}: Set this to \code{true} to force the request to use path-style addressing, i.e. \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
\item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
}}

\item{credentials}{Optional credentials shorthand for the config parameter
\itemize{
\item{\strong{creds}: \itemize{
\item{\strong{access_key_id}: AWS access key ID}
\item{\strong{secret_access_key}: AWS secret access key}
\item{\strong{session_token}: AWS temporary session token}
}}
\item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}: Set anonymous credentials.}
}}

\item{endpoint}{Optional shorthand for complete URL to use for the constructed client.}

\item{region}{Optional shorthand for AWS Region used in instantiating the client.}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Web Services Private CA Connector for Active Directory creates a
connector between Amazon Web Services Private CA and Active Directory
(AD) that enables you to provision security certificates for AD signed
by a private CA that you own. For more information, see \href{https://docs.aws.amazon.com/privateca/latest/userguide/}{Amazon Web Services Private CA Connector for Active Directory}.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- pcaconnectorad(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical",
    sts_regional_endpoint = "string"
  ),
  credentials = list(
    creds = list(
      access_key_id = "string",
      secret_access_key = "string",
      session_token = "string"
    ),
    profile = "string",
    anonymous = "logical"
  ),
  endpoint = "string",
  region = "string"
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=pcaconnectorad_create_connector]{create_connector} \tab Creates a connector between Amazon Web Services Private CA and an Active Directory\cr
\link[=pcaconnectorad_create_directory_registration]{create_directory_registration} \tab Creates a directory registration that authorizes communication between Amazon Web Services Private CA and an Active Directory\cr
\link[=pcaconnectorad_create_service_principal_name]{create_service_principal_name} \tab Creates a service principal name (SPN) for the service account in Active Directory\cr
\link[=pcaconnectorad_create_template]{create_template} \tab Creates an Active Directory compatible certificate template\cr
\link[=pcaconnectorad_create_template_group_access_control_entry]{create_template_group_access_control_entry} \tab Create a group access control entry\cr
\link[=pcaconnectorad_delete_connector]{delete_connector} \tab Deletes a connector for Active Directory\cr
\link[=pcaconnectorad_delete_directory_registration]{delete_directory_registration} \tab Deletes a directory registration\cr
\link[=pcaconnectorad_delete_service_principal_name]{delete_service_principal_name} \tab Deletes the service principal name (SPN) used by a connector to authenticate with your Active Directory\cr
\link[=pcaconnectorad_delete_template]{delete_template} \tab Deletes a template\cr
\link[=pcaconnectorad_delete_template_group_access_control_entry]{delete_template_group_access_control_entry} \tab Deletes a group access control entry\cr
\link[=pcaconnectorad_get_connector]{get_connector} \tab Lists information about your connector\cr
\link[=pcaconnectorad_get_directory_registration]{get_directory_registration} \tab A structure that contains information about your directory registration\cr
\link[=pcaconnectorad_get_service_principal_name]{get_service_principal_name} \tab Lists the service principal name that the connector uses to authenticate with Active Directory\cr
\link[=pcaconnectorad_get_template]{get_template} \tab Retrieves a certificate template that the connector uses to issue certificates from a private CA\cr
\link[=pcaconnectorad_get_template_group_access_control_entry]{get_template_group_access_control_entry} \tab Retrieves the group access control entries for a template\cr
\link[=pcaconnectorad_list_connectors]{list_connectors} \tab Lists the connectors that you created by using the https://docs\cr
\link[=pcaconnectorad_list_directory_registrations]{list_directory_registrations} \tab Lists the directory registrations that you created by using the https://docs\cr
\link[=pcaconnectorad_list_service_principal_names]{list_service_principal_names} \tab Lists the service principal names that the connector uses to authenticate with Active Directory\cr
\link[=pcaconnectorad_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags, if any, that are associated with your resource\cr
\link[=pcaconnectorad_list_template_group_access_control_entries]{list_template_group_access_control_entries} \tab Lists group access control entries you created\cr
\link[=pcaconnectorad_list_templates]{list_templates} \tab Lists the templates, if any, that are associated with a connector\cr
\link[=pcaconnectorad_tag_resource]{tag_resource} \tab Adds one or more tags to your resource\cr
\link[=pcaconnectorad_untag_resource]{untag_resource} \tab Removes one or more tags from your resource\cr
\link[=pcaconnectorad_update_template]{update_template} \tab Update template configuration to define the information included in certificates\cr
\link[=pcaconnectorad_update_template_group_access_control_entry]{update_template_group_access_control_entry} \tab Update a group access control entry you created using CreateTemplateGroupAccessControlEntry
}
}

\examples{
\dontrun{
svc <- pcaconnectorad()
svc$create_connector(
  Foo = 123
)
}

}
