% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_confirm_sign_up}
\alias{cognitoidentityprovider_admin_confirm_sign_up}
\title{Confirms user sign-up as an administrator}
\usage{
cognitoidentityprovider_admin_confirm_sign_up(
  UserPoolId,
  Username,
  ClientMetadata = NULL
)
}
\arguments{
\item{UserPoolId}{[required] The ID of the user pool where you want to confirm a user's sign-up
request.}

\item{Username}{[required] The username of the user that you want to query or modify. The value of
this parameter is typically your user's username, but it can be any of
their alias attributes. If \code{username} isn't an alias attribute in your
user pool, this value must be the \code{sub} of a local user or the username
of a user from a third-party IdP.}

\item{ClientMetadata}{A map of custom key-value pairs that you can provide as input for any
custom workflows that this action triggers.

If your user pool configuration includes triggers, the
AdminConfirmSignUp API action invokes the Lambda function that is
specified for the \emph{post confirmation} trigger. When Amazon Cognito
invokes this function, it passes a JSON payload, which the function
receives as input. In this payload, the \code{clientMetadata} attribute
provides the data that you assigned to the ClientMetadata parameter in
your AdminConfirmSignUp request. In your function code in Lambda, you
can process the ClientMetadata value to enhance your workflow for your
specific needs.

For more information, see \href{https://docs.aws.amazon.com/cognito/latest/developerguide/cognito-user-pools-working-with-lambda-triggers.html}{Customizing user pool Workflows with Lambda Triggers}
in the \emph{Amazon Cognito Developer Guide}.

When you use the \code{ClientMetadata} parameter, note that Amazon Cognito
won't do the following:
\itemize{
\item Store the \code{ClientMetadata} value. This data is available only to
Lambda triggers that are assigned to a user pool to support custom
workflows. If your user pool configuration doesn't include triggers,
the \code{ClientMetadata} parameter serves no purpose.
\item Validate the \code{ClientMetadata} value.
\item Encrypt the \code{ClientMetadata} value. Don't send sensitive information
in this parameter.
}}
}
\description{
Confirms user sign-up as an administrator. Unlike \code{\link[=cognitoidentityprovider_confirm_sign_up]{confirm_sign_up}}, your IAM credentials authorize user account confirmation. No confirmation code is required.

See \url{https://www.paws-r-sdk.com/docs/cognitoidentityprovider_admin_confirm_sign_up/} for full documentation.
}
\keyword{internal}
