% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_put_bucket_tagging}
\alias{s3control_put_bucket_tagging}
\title{This action puts tags on an Amazon S3 on Outposts bucket}
\usage{
s3control_put_bucket_tagging(AccountId, Bucket, Tagging)
}
\arguments{
\item{AccountId}{[required] The AWS account ID of the Outposts bucket.}

\item{Bucket}{[required] The Amazon Resource Name (ARN) of the bucket.

For using this parameter with Amazon S3 on Outposts with the REST API,
you must specify the name and the x-amz-outpost-id as well.

For using this parameter with S3 on Outposts with the AWS SDK and CLI,
you must specify the ARN of the bucket accessed in the format
\verb{arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>}.
For example, to access the bucket \code{reports} through outpost \code{my-outpost}
owned by account \code{123456789012} in Region \code{us-west-2}, use the URL
encoding of
\code{arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports}.
The value must be URL encoded.}

\item{Tagging}{[required]}
}
\value{
An empty list.
}
\description{
This action puts tags on an Amazon S3 on Outposts bucket. To put tags on
an S3 bucket, see \code{\link[=s3control_put_bucket_tagging]{put_bucket_tagging}}
in the \emph{Amazon Simple Storage Service API}.

Sets the tags for an Outposts bucket. For more information, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon Simple Storage Service Developer Guide}.

Use tags to organize your AWS bill to reflect your own cost structure.
To do this, sign up to get your AWS account bill with tag key values
included. Then, to see the cost of combined resources, organize your
billing information according to resources with the same tag key values.
For example, you can tag several resources with a specific application
name, and then organize your billing information to see the total cost
of that application across several services. For more information, see
\href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/cost-alloc-tags.html}{Cost Allocation and Tagging}.

Within a bucket, if you add a tag that has the same key as an existing
tag, the new value overwrites the old value. For more information, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/CostAllocTagging.html}{Using Cost Allocation in Amazon S3 Bucket Tags}.

To use this operation, you must have permissions to perform the
\code{s3-outposts:PutBucketTagging} action. The Outposts bucket owner has
this permission by default and can grant this permission to others. For
more information about permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-with-s3-actions.html#using-with-s3-actions-related-to-bucket-subresources}{Permissions Related to Bucket Subresource Operations}
and \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/s3-access-control.html}{Managing Access Permissions to Your Amazon S3 Resources}.

\code{\link[=s3control_put_bucket_tagging]{put_bucket_tagging}} has the following
special errors:
\itemize{
\item Error code: \code{InvalidTagError}
\itemize{
\item Description: The tag provided was not a valid tag. This error
can occur if the tag did not pass input validation. For
information about tag restrictions, see \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/allocation-tag-restrictions.html}{User-Defined Tag Restrictions}
and \href{https://docs.aws.amazon.com/awsaccountbilling/latest/aboutv2/aws-tag-restrictions.html}{AWS-Generated Cost Allocation Tag Restrictions}.
}
\item Error code: \code{MalformedXMLError}
\itemize{
\item Description: The XML provided does not match the schema.
}
\item Error code: \code{OperationAbortedError }
\itemize{
\item Description: A conflicting conditional operation is currently in
progress against this resource. Try again.
}
\item Error code: \code{InternalError}
\itemize{
\item Description: The service was unable to apply the provided tag to
the bucket.
}
}

All Amazon S3 on Outposts REST API requests for this action require an
additional parameter of \code{x-amz-outpost-id} to be passed with the request
and an S3 on Outposts endpoint hostname prefix instead of \code{s3-control}.
For an example of the request syntax for Amazon S3 on Outposts that uses
the S3 on Outposts endpoint hostname prefix and the \code{x-amz-outpost-id}
derived using the access point ARN, see the
\href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_control_PutBucketTagging.html#API_control_PutBucketTagging_Examples}{Examples}
section.

The following actions are related to
\code{\link[=s3control_put_bucket_tagging]{put_bucket_tagging}}:
\itemize{
\item \code{\link[=s3control_get_bucket_tagging]{get_bucket_tagging}}
\item \code{\link[=s3control_delete_bucket_tagging]{delete_bucket_tagging}}
}
}
\section{Request syntax}{
\preformatted{svc$put_bucket_tagging(
  AccountId = "string",
  Bucket = "string",
  Tagging = list(
    TagSet = list(
      list(
        Key = "string",
        Value = "string"
      )
    )
  )
)
}
}

\keyword{internal}
