% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_access_point}
\alias{s3control_create_access_point}
\title{Creates an access point and associates it with the specified bucket}
\usage{
s3control_create_access_point(AccountId, Name, Bucket, VpcConfiguration,
  PublicAccessBlockConfiguration)
}
\arguments{
\item{AccountId}{[required] The AWS account ID for the owner of the bucket for which you want to
create an access point.}

\item{Name}{[required] The name you want to assign to this access point.}

\item{Bucket}{[required] The name of the bucket that you want to associate this access point
with.}

\item{VpcConfiguration}{If you include this field, Amazon S3 restricts access to this access
point to requests from the specified Virtual Private Cloud (VPC).}

\item{PublicAccessBlockConfiguration}{}
}
\description{
Creates an access point and associates it with the specified bucket.
}
\section{Request syntax}{
\preformatted{svc$create_access_point(
  AccountId = "string",
  Name = "string",
  Bucket = "string",
  VpcConfiguration = list(
    VpcId = "string"
  ),
  PublicAccessBlockConfiguration = list(
    BlockPublicAcls = TRUE|FALSE,
    IgnorePublicAcls = TRUE|FALSE,
    BlockPublicPolicy = TRUE|FALSE,
    RestrictPublicBuckets = TRUE|FALSE
  )
)
}
}

\keyword{internal}
