% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3control_operations.R
\name{s3control_create_bucket}
\alias{s3control_create_bucket}
\title{This action creates an Amazon S3 on Outposts bucket}
\usage{
s3control_create_bucket(
  ACL = NULL,
  Bucket,
  CreateBucketConfiguration = NULL,
  GrantFullControl = NULL,
  GrantRead = NULL,
  GrantReadACP = NULL,
  GrantWrite = NULL,
  GrantWriteACP = NULL,
  ObjectLockEnabledForBucket = NULL,
  OutpostId = NULL
)
}
\arguments{
\item{ACL}{The canned ACL to apply to the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{Bucket}{[required] The name of the bucket.}

\item{CreateBucketConfiguration}{The configuration information for the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantWrite}{Allows grantee to create, overwrite, and delete any object in the
bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{ObjectLockEnabledForBucket}{Specifies whether you want S3 Object Lock to be enabled for the new
bucket.

This is not supported by Amazon S3 on Outposts buckets.}

\item{OutpostId}{The ID of the Outposts where the bucket is being created.

This is required by Amazon S3 on Outposts buckets.}
}
\description{
This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html}{Create Bucket} in the \emph{Amazon S3 API Reference}.

See \url{https://paws-r.github.io/docs/s3control/create_bucket.html} for full documentation.
}
\keyword{internal}
