% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backup_operations.R
\name{backup_create_report_plan}
\alias{backup_create_report_plan}
\title{Creates a report plan}
\usage{
backup_create_report_plan(
  ReportPlanName,
  ReportPlanDescription = NULL,
  ReportDeliveryChannel,
  ReportSetting,
  ReportPlanTags = NULL,
  IdempotencyToken = NULL
)
}
\arguments{
\item{ReportPlanName}{[required] The unique name of the report plan. The name must be between 1 and 256
characters, starting with a letter, and consisting of letters (a-z,
A-Z), numbers (0-9), and underscores (_).}

\item{ReportPlanDescription}{An optional description of the report plan with a maximum of 1,024
characters.}

\item{ReportDeliveryChannel}{[required] A structure that contains information about where and how to deliver
your reports, specifically your Amazon S3 bucket name, S3 key prefix,
and the formats of your reports.}

\item{ReportSetting}{[required] Identifies the report template for the report. Reports are built using a
report template. The report templates are:

\code{RESOURCE_COMPLIANCE_REPORT | CONTROL_COMPLIANCE_REPORT | BACKUP_JOB_REPORT | COPY_JOB_REPORT | RESTORE_JOB_REPORT}

If the report template is \code{RESOURCE_COMPLIANCE_REPORT} or
\code{CONTROL_COMPLIANCE_REPORT}, this API resource also describes the report
coverage by Amazon Web Services Regions and frameworks.}

\item{ReportPlanTags}{The tags to assign to the report plan.}

\item{IdempotencyToken}{A customer-chosen string that you can use to distinguish between
otherwise identical calls to \code{CreateReportPlanInput}. Retrying a
successful request with the same idempotency token results in a success
message with no action taken.}
}
\description{
Creates a report plan. A report plan is a document that contains information about the contents of the report and where Backup will deliver it.

See \url{https://www.paws-r-sdk.com/docs/backup_create_report_plan/} for full documentation.
}
\keyword{internal}
