% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{lookoutequipment}
\alias{lookoutequipment}
\title{Amazon Lookout for Equipment}
\usage{
lookoutequipment(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
Amazon Lookout for Equipment is a machine learning service that uses
advanced analytics to identify anomalies in machines from sensor data
for use in predictive maintenance.
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- lookoutequipment(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.machine.learning:lookoutequipment_create_dataset]{create_dataset} \tab Creates a container for a collection of data being ingested for analysis\cr
\link[paws.machine.learning:lookoutequipment_create_inference_scheduler]{create_inference_scheduler} \tab Creates a scheduled inference\cr
\link[paws.machine.learning:lookoutequipment_create_model]{create_model} \tab Creates an ML model for data inference\cr
\link[paws.machine.learning:lookoutequipment_delete_dataset]{delete_dataset} \tab Deletes a dataset and associated artifacts\cr
\link[paws.machine.learning:lookoutequipment_delete_inference_scheduler]{delete_inference_scheduler} \tab Deletes an inference scheduler that has been set up\cr
\link[paws.machine.learning:lookoutequipment_delete_model]{delete_model} \tab Deletes an ML model currently available for Amazon Lookout for Equipment\cr
\link[paws.machine.learning:lookoutequipment_describe_data_ingestion_job]{describe_data_ingestion_job} \tab Provides information on a specific data ingestion job such as creation time, dataset ARN, and status\cr
\link[paws.machine.learning:lookoutequipment_describe_dataset]{describe_dataset} \tab Provides a JSON description of the data in each time series dataset, including names, column names, and data types\cr
\link[paws.machine.learning:lookoutequipment_describe_inference_scheduler]{describe_inference_scheduler} \tab Specifies information about the inference scheduler being used, including name, model, status, and associated metadata\cr
\link[paws.machine.learning:lookoutequipment_describe_model]{describe_model} \tab Provides a JSON containing the overall information about a specific ML model, including model name and ARN, dataset, training and evaluation information, status, and so on\cr
\link[paws.machine.learning:lookoutequipment_list_data_ingestion_jobs]{list_data_ingestion_jobs} \tab Provides a list of all data ingestion jobs, including dataset name and ARN, S3 location of the input data, status, and so on\cr
\link[paws.machine.learning:lookoutequipment_list_datasets]{list_datasets} \tab Lists all datasets currently available in your account, filtering on the dataset name\cr
\link[paws.machine.learning:lookoutequipment_list_inference_events]{list_inference_events} \tab Lists all inference events that have been found for the specified inference scheduler\cr
\link[paws.machine.learning:lookoutequipment_list_inference_executions]{list_inference_executions} \tab Lists all inference executions that have been performed by the specified inference scheduler\cr
\link[paws.machine.learning:lookoutequipment_list_inference_schedulers]{list_inference_schedulers} \tab Retrieves a list of all inference schedulers currently available for your account\cr
\link[paws.machine.learning:lookoutequipment_list_models]{list_models} \tab Generates a list of all models in the account, including model name and ARN, dataset, and status\cr
\link[paws.machine.learning:lookoutequipment_list_sensor_statistics]{list_sensor_statistics} \tab Lists statistics about the data collected for each of the sensors that have been successfully ingested in the particular dataset\cr
\link[paws.machine.learning:lookoutequipment_list_tags_for_resource]{list_tags_for_resource} \tab Lists all the tags for a specified resource, including key and value\cr
\link[paws.machine.learning:lookoutequipment_start_data_ingestion_job]{start_data_ingestion_job} \tab Starts a data ingestion job\cr
\link[paws.machine.learning:lookoutequipment_start_inference_scheduler]{start_inference_scheduler} \tab Starts an inference scheduler\cr
\link[paws.machine.learning:lookoutequipment_stop_inference_scheduler]{stop_inference_scheduler} \tab Stops an inference scheduler\cr
\link[paws.machine.learning:lookoutequipment_tag_resource]{tag_resource} \tab Associates a given tag to a resource in your account\cr
\link[paws.machine.learning:lookoutequipment_untag_resource]{untag_resource} \tab Removes a specific tag from a given resource\cr
\link[paws.machine.learning:lookoutequipment_update_inference_scheduler]{update_inference_scheduler} \tab Updates an inference scheduler
}
}

\examples{
\dontrun{
svc <- lookoutequipment()
svc$create_dataset(
  Foo = 123
)
}

}
