% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paws.R
\name{qldbsession}
\alias{qldbsession}
\title{Amazon QLDB Session}
\usage{
qldbsession(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
The transactional data APIs for Amazon QLDB

Instead of interacting directly with this API, we recommend using the
QLDB driver or the QLDB shell to execute data transactions on a ledger.
\itemize{
\item If you are working with an AWS SDK, use the QLDB driver. The driver
provides a high-level abstraction layer above this \emph{QLDB Session}
data plane and manages \code{send_command}
API calls for you. For information and a list of supported
programming languages, see \href{https://docs.aws.amazon.com/qldb/latest/developerguide/getting-started-driver.html}{Getting started with the driver}
in the \emph{Amazon QLDB Developer Guide}.
\item If you are working with the AWS Command Line Interface (AWS CLI),
use the QLDB shell. The shell is a command line interface that uses
the QLDB driver to interact with a ledger. For information, see
\href{https://docs.aws.amazon.com/qldb/latest/developerguide/data-shell.html}{Accessing Amazon QLDB using the QLDB shell}.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- qldbsession(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[paws.database:qldbsession_send_command]{send_command} \tab Sends a command to an Amazon QLDB ledger
}
}

\examples{
\dontrun{
svc <- qldbsession()
svc$send_command(
  Foo = 123
)
}

}
