% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/random_port.r
\name{random_port}
\alias{random_open_port}
\alias{random_port}
\title{Random Port}
\usage{
random_port(min_port = 49152, max_port = 65536)

random_open_port(min_port = 49152, max_port = 65536, max_tries = 100)
}
\arguments{
\item{min_port, max_port}{The minimum/maximum value to be generated.  The minimum should not
be below 49152 and the maximum should not exceed 65536 (see
details).}

\item{max_tries}{The maximum number of times a random port will be searched for.}
}
\description{
Generate a valid, random TCP port.
}
\details{
By definition, a TCP port is an unsigned short, and so it can not
exceed 65535.  Additionally, ports in the range 1024 to 49151 are
(possibly) registered by ICANN for specific uses.

\code{random_port()} will simply generate a valid, non-registered
tcp port.  \code{random_unused_port()} will generate a port
that is available for socket connections.

\code{random_open_port()} finds a random port not already bound
to an endpoint.
}
\examples{
random_port()

}
\author{
Drew Schmidt
}
\references{
"The Ephemeral Port Range" by Mike Gleason.  
\url{http://www.ncftp.com/ncftpd/doc/misc/ephemeral_ports.html}
}

