% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_extract_images.R
\name{f_extract_images}
\alias{f_extract_images}
\title{Get an Image File from the Collection of Files Compressed in a '.pbix'}
\usage{
f_extract_images(input_file_pbix, image_reg)
}
\arguments{
\item{input_file_pbix}{Path of the input '.pbix'.}

\item{image_reg}{Pattern used to search for an image file stored in
a collection of files compressed in '.pbix' (e.g., "[.]png|[.]jpg").}
}
\value{
A list: [[1]] a temporary location for an image, [[2]] the
name, length (kb) and date associated with an image.
}
\description{
The collection of files compressed in a '.pbix' is searched for
images. An image is written to a temporary file. The path of the
temporary file and associated properties are returned.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

image_reg <- "[.]png|[.]jpg"
# Run the function
test <- f_extract_images(pathFileSample, image_reg)
# Plot the image
im <- imager::load.image(test[[1]])
plot(im)
  }
}
\seealso{
Uses: \code{\link{f_get_pbix_info}},
\code{\link{f_get_pbix_fir}}.
}
\author{
Don Diproto
}
