% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/f_get_connections.R
\name{f_get_connections}
\alias{f_get_connections}
\title{Get 'Analysis Services' Connections to an Open '.pbix'}
\usage{
f_get_connections()
}
\value{
The '.pbix' and associated port.
}
\description{
A query to link an open '.pbix'(s) with relevant
'Analysis Services' connection
information is developed. The query is executed via 'PowerShell'.
}
\note{
An input is not required for this function. 'Power BI' and
'PowerShell' are required.
}
\examples{
\dontrun{
# Get dummy data ------------------------------------------------------------
# Create a temporary directory
temp_dir <- file.path(tempdir(),"functionTest")
if(!dir.exists(temp_dir)) {
	dir.create(temp_dir)
}
sample_file_name <- "OR_sample_func.pbix"
pathFileSample <- file.path(temp_dir, sample_file_name)

# See if dummy data already exists in temporary directory
parent_temp_dir <- dirname(temp_dir)
existing_file <- list.files(parent_temp_dir,
pattern = sample_file_name, recursive = TRUE, full.names = TRUE)

# Download the sample .pbix if it doesn't exist
if (length(existing_file) == 0) {
   url_pt1 <- "https://github.com/KoenVerbeeck/PowerBI-Course/blob/"
   url_pt2 <- "master/pbix/TopMovies.pbix?raw=true"
   url <- paste0(url_pt1, url_pt2)
   req <- download.file(url, destfile = pathFileSample, mode = "wb")
} else {
   pathFileSample <- existing_file[1]
}
# Do stuff ------------------------------------------------------------------

#
# Open the .pbix with 'Power BI' if it is not already open.
#
# Run the function
connections_open <- f_get_connections()
  }
}
\author{
Don Diproto
}
