% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-coerce.R
\name{model-coerce}
\alias{model-coerce}
\alias{model2remat}
\alias{remat2model}
\alias{make_modelmat}
\alias{make_remat}
\title{Conversion between a model object and a restriction matrix}
\usage{
model2remat(largeModel, smallModel, sparse = FALSE)

remat2model(largeModel, L, REML = TRUE, ...)

make_modelmat(X, L)

make_remat(X, X2)
}
\arguments{
\item{largeModel, smallModel}{Model objects of the same "type". Possible types
are linear mixed effects models and linear models (including generalized
linear models)}

\item{sparse}{Should the restriction matrix be sparse or dense?}

\item{L}{A restriction matrix; a full rank matrix with as many columns as `X` has.}

\item{REML}{Controls if new model object should be fitted with REML or ML.}

\item{...}{Additional arguments; not used.}

\item{X, X2}{Model matrices. Must have same numer of rows.}
}
\value{
\code{model2remat}: A restriction matrix.
    \code{remat2model}: A model object.
}
\description{
Testing a small model under a large model corresponds
    imposing restrictions on the model matrix of the larger model
    and these restrictions come in the form of a restriction
    matrix. These functions converts a model to a restriction
    matrix and vice versa.
}
\details{
`make_remat` Make a restriction matrix. If span(X2) is in
    span(X) then the corresponding restriction matrix `L` is
    returned.
}
\note{
That these functions are visible is a recent addition; minor changes
    may occur.
}
\examples{
library(pbkrtest)
data("beets", package = "pbkrtest")
sug <- lm(sugpct ~ block + sow + harvest, data=beets)
sug.h <- update(sug, .~. - harvest)
sug.s <- update(sug, .~. - sow)

## Construct restriction matrices from models
L.h <- model2remat(sug, sug.h); L.h
L.s <- model2remat(sug, sug.s); L.s

## Construct submodels from restriction matrices
mod.h <- remat2model(sug, L.h); mod.h
mod.s <- remat2model(sug, L.s); mod.s

## Sanity check: The models have the same fitted values and log likelihood
plot(fitted(mod.h), fitted(sug.h))
plot(fitted(mod.s), fitted(sug.s))
logLik(mod.h)
logLik(sug.h)
logLik(mod.s)
logLik(sug.s)
}
\references{
Ulrich Halekoh, Søren Højsgaard (2014)., A Kenward-Roger
    Approximation and Parametric Bootstrap Methods for Tests in Linear Mixed
    Models - The R Package pbkrtest., Journal of Statistical Software,
    58(10), 1-30., \url{https://www.jstatsoft.org/v59/i09/}
}
\seealso{
\code{\link{PBmodcomp}}, \code{\link{PBrefdist}},
    \code{\link{KRmodcomp}}
}
\author{
Ulrich Halekoh \email{uhalekoh@health.sdu.dk}, Søren Højsgaard
    \email{sorenh@math.aau.dk}
}
\keyword{utilities}
