% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndCSTe.domset}
\alias{IndCSTe.domset}
\title{The indicator for the set of points \code{S} being a dominating set or not for Central Similarity Proximity
Catch Digraphs (CS-PCDs) - standard equilateral triangle case}
\usage{
IndCSTe.domset(S, Dt, t, M = c(1, 1, 1))
}
\arguments{
\item{S}{A set of 2D points which is to be tested for being a dominating set for the CS-PCDs}

\item{Dt}{A set of 2D points which constitute the vertices of the CS-PCD}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region in the
standard equilateral triangle \eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))}}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}; default is \eqn{M=(1,1,1)} i.e.
the center of mass of \eqn{T_e}}
}
\value{
I(\code{S} a dominating set of CS-PCD), that is, returns 1 if \code{S} is a dominating set of CS-PCD,
returns 0 otherwise, where CS proximity region is constructed in the standard equilateral triangle \eqn{T_e}
}
\description{
Returns I(\code{S} a dominating set of the CS-PCD) where the vertices of the CS-PCD are the data set \code{Dt}), that is,
returns 1 if \code{S} is a dominating set of CS-PCD, returns 0 otherwise.

CS proximity region is constructed
with respect to the standard equilateral triangle \eqn{T_e=T(A,B,C)=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with
expansion parameter \eqn{t>0} and edge regions are based on the center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e};
default is \eqn{M=(1,1,1)} i.e. the center of mass of \eqn{T_e} (which is equivalent to the circumcenter of \eqn{T_e}).

Edges of \eqn{T_e}, \eqn{AB}, \eqn{BC}, \eqn{AC}, are also labeled as 3, 1, and 2, respectively.

See also (\insertCite{ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C);
n<-10

set.seed(1)
dat<-runifTe(n)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

t<-.5

S<-rbind(dat[1,],dat[2,])
IndCSTe.domset(S,dat,t,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,])
IndCSTe.domset(S,dat,t,M)

S<-rbind(c(.1,.1),c(.3,.4),c(.5,.3))
IndCSTe.domset(S,dat,t,M)

IndCSTe.domset(c(.2,.5),dat,t,M)
IndCSTe.domset(c(.2,.5),c(.2,.5),t,M)
IndCSTe.domset(dat[5,],dat[2,],t,M)

S<-rbind(dat[1,],dat[2,],dat[3,],dat[5,],c(.2,.5))
IndCSTe.domset(S,dat[3,],t,M)

IndCSTe.domset(dat,dat,t,M)

P<-c(.4,.2)
S<-dat[c(1,3,4),]
IndCSTe.domset(dat,P,t,M)
IndCSTe.domset(S,P,t,M)
IndCSTe.domset(S,dat,t,M)

IndCSTe.domset(rbind(S,S),dat,t,M)

dat.fr<-data.frame(a=dat)
IndCSTe.domset(S,dat.fr,t,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNCStri.domset}} and \code{\link{IndNPETe.domset}}
}
