% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{Gam1CS1D}
\alias{Gam1CS1D}
\title{The indicator for a point being a dominating point for Central Similarity
Proximity Catch Digraphs (CS-PCDs) for an interval}
\usage{
Gam1CS1D(p, Dt, t, c, int, rv = NULL, ch.data.pnt = FALSE)
}
\arguments{
\item{p}{A 1D point that is to be tested for being a dominating point or not of the CS-PCD.}

\item{Dt}{A set of 1D points which constitutes the vertices of the CS-PCD.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{c}{A positive real number in \eqn{(0,1)} parameterizing the center inside \eqn{int=(a,b)}.
For the interval, \eqn{int=(a,b)}, the parameterized center is \eqn{M_c=a+c(b-a)}; default c=.5.}

\item{int}{A vector of two real numbers representing an interval.}

\item{rv}{Index of the vertex region in which the point resides, either 1, 2 or \code{NULL}
(default is \code{NULL}).}

\item{ch.data.pnt}{A logical argument for checking whether point \code{p} is a data point
in \code{Dt} or not (default is \code{FALSE}).}
}
\value{
I(\code{p} is a dominating point of CS-PCD) where the vertices of the CS-PCD are the 1D data set \code{Dt}),
that is, returns 1 if \code{p} is a dominating point, returns 0 otherwise
}
\description{
Returns I(\code{p} is a dominating point of CS-PCD) where the vertices of the CS-PCD are the 1D data set \code{Dt}).

CS proximity region is defined with respect to the interval \code{int} with an expansion parameter, \eqn{t>0},
and a centrality parameter, \code{c} in \eqn{(0,1)}, so arcs may exist for \code{Dt} points inside the interval \eqn{int=(a,b)}.

Vertex regions are based on the center associated with the centrality parameter \code{c} in \eqn{(0,1)}.
\code{rv} is the index of the vertex region p resides, with default=\code{NULL}.

\code{ch.data.pnt} is for checking whether point \code{p} is a data point in \code{Dt} or not (default is \code{FALSE}),
so by default this function checks whether the point \code{p} would be a dominating point
if it actually were in the data set.
}
\examples{
t<-2
c<-.4
a<-0; b<-10; int<-c(a,b)

Mc<-centMc(int,c)
n<-10

set.seed(1)
dat<-runif(n,a,b)

Gam1CS1D(dat[5],dat,t,c,int)
\dontrun{
Gam1CS1D(2,dat,t,c,int,ch.data.pnt = TRUE)  #p is not a data point in Dt
}

gam.vec<-vector()
for (i in 1:n)
{gam.vec<-c(gam.vec,Gam1CS1D(dat[i],dat,t,c,int))}

ind.gam1<-which(gam.vec==1)
ind.gam1

domset<-dat[ind.gam1]
if (length(ind.gam1)==0)
{domset<-NA}

#or try
Rv<-rv.mid.int(dat[5],c,int)$rv
Gam1CS1D(dat[5],dat,t,c,int,Rv)

Xlim<-range(a,b,dat)
xd<-Xlim[2]-Xlim[1]

plot(cbind(a,0),xlab="",pch=".",xlim=Xlim+xd*c(-.05,.05))
abline(h=0)
abline(v=c(a,b,Mc),col=c(1,1,2),lty=2)
points(cbind(dat,0))
points(cbind(domset,0),pch=4,col=2)
text(cbind(c(a,b,Mc),-0.1),c("a","b","Mc"))

Gam1CS1D(dat[5],dat,t,c,int)

n<-10
dat2<-runif(n,a+b,b+10)
Gam1CS1D(5,dat2,t,c,int)

}
\seealso{
\code{\link{Gam1PE1D}}
}
