% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{IndNCStri.alt}
\alias{IndNCStri.alt}
\title{An alternative function to the function \code{\link{IndNCStri}} which yields the indicator for the presence of an arc
from one point to another for Central Similarity Proximity Catch Digraphs (CS-PCDs)}
\usage{
IndNCStri.alt(pt1, pt2, t, tri, re = NULL)
}
\arguments{
\item{pt1}{A 2D point whose CS proximity region is constructed.}

\item{pt2}{A 2D point. The function determines whether \code{pt2} is inside the CS proximity region of
\code{pt1} or not.}

\item{t}{A positive real number which serves as the expansion parameter in CS proximity region.}

\item{tri}{Three 2D points, stacked row-wise, each row representing a vertex of the triangle.}

\item{re}{Index of the CM-edge region containing the point \code{pt},
either 1, 2, 3 or \code{NULL}, default=\code{NULL} but
must be provided (row-wise) as vertices \eqn{(y_1,y_2,y_3)} for \eqn{re=3} as \eqn{(y_2,y_3,y_1)} for
\eqn{re=1} and as \eqn{(y_1,y_3,y_2)} for \eqn{re=2} for triangle \eqn{T(y_1,y_2,y_3)}.}
}
\value{
I(\code{pt2} is in \eqn{NCS(pt1,t)}) for \code{pt1}, that is,
returns 1 if \code{pt2} is in \eqn{NCS(pt1,t)}, returns 0 otherwise.
}
\description{
Returns I(\code{pt2} is in \eqn{NCS(pt1,t)}) for points \code{pt1} and \code{pt2}, that is, returns 1 if \code{pt2} is in \eqn{NCS(pt1,t)},
returns 0 otherwise, where \eqn{NCS(x,t)} is the CS proximity region for point \eqn{x} with the expansion parameter \eqn{t>0}.

CS proximity region is constructed with respect to the triangle \code{tri} and edge regions are based on the
center of mass, CM. \code{re} is the index of the CM-edge region \code{pt} resides, with default=\code{NULL} but must be provided as
vertices \eqn{(y_1,y_2,y_3)} for \eqn{re=3} as rbind(y2,y3,y1) for \eqn{re=1} and as rbind(y1,y3,y2) for \eqn{re=2} for triangle \eqn{T(y_1,y_2,y_3)}.

If \code{pt1} and \code{pt2} are distint and either of them are outside \code{tri}, it returns 0,
but if they are identical, then it returns 1 regardless of their locations (i.e., it allows loops).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-CS,ceyhan:test2014;textual}{pcds}).
}
\examples{
\dontrun{
A<-c(1,1); B<-c(2,0); C<-c(1.6,2);
Tr<-rbind(A,B,C);
t<-1.5

P1<-c(.4,.2)
P2<-c(1.8,.5)
IndNCStri(P1,P2,t,Tr,M=c(1,1,1))
IndNCStri.alt(P1,P2,t,Tr)

IndNCStri(P1,P1,t,Tr,M=c(1,1,1))
IndNCStri.alt(P1,P1,t,Tr)

IndNCStri(P2,P1,t,Tr,M=c(1,1,1))
IndNCStri.alt(P2,P1,t,Tr)

IndNCStri(P2,P2,t,Tr,M=c(1,1,1))
IndNCStri.alt(P2,P2,t,Tr)

P3<-c(1.7,.6)
IndNCStri(P2,P3,t,Tr,M=c(1,1,1))
IndNCStri.alt(P2,P3,t,Tr)

IndNCStri(P3,P2,t,Tr,M=c(1,1,1))
IndNCStri.alt(P3,P2,t,Tr)

#or try
re<-redges.triCM(P1,Tr)$re
IndNCStri(P1,P2,t,Tr,M=c(1,1,1),re)
IndNCStri.alt(P1,P2,t,Tr,re)

P2<-c(1.85,.5); P3<-c(1.7,.6)
IndNCStri.alt(P2,P3,t,Tr)

dat.fr<-data.frame(a=Tr)
IndNCStri.alt(P2,P3,t,dat.fr)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{IndNAStri}}, \code{\link{IndNPEtri}}, \code{\link{IndNCStri}}, and \code{\link{IndCSTe}}
}
