% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibratePCRsim.r
\name{calibratePCRsim}
\alias{calibratePCRsim}
\title{Calibrate PCRsim}
\usage{
calibratePCRsim(data, target = NULL, ref = NULL, quant = NULL,
  ignore.case = TRUE, kit = NULL, db = NULL, fixed.profile = NULL,
  sim = 1, pcr.cyc, ce.aliq = 1, pcr.aliq = 17.5, pcr.vol = 25,
  minimize = TRUE, step.size = 0.001, cell.dna = 0.006,
  dna.amount = 0.5, filter = TRUE, plot.data = TRUE, decimals = 4,
  debug = FALSE, ext.debug = FALSE)
}
\arguments{
\item{data}{data.frame with observed DNA result. Required columns are sample names ('Sample.Name'),
average peak height ('H'), and (mean) DNA concentration ('Mean').}

\item{target}{integer average peak height ('H') as observed average across replicate
analyses of samples with \code{dna.amount} of DNA.
If NULL it will be estimated from the linear regression at \code{dna.amount} of DNA.}

\item{ref}{data.frame with known profiles for the samples in \code{data}. 
Required columns are 'Sample.Name', 'Marker', and ('Allele'), and (mean) DNA concentration ('Mean').}

\item{quant}{data.frame with (average) 'Concentration' or 'Amount' for the samples in \code{data}.}

\item{ignore.case}{logical \code{TRUE} to ignore case in sample name matching.}

\item{kit}{character string to specify the STR DNA typing kit to simulate.
If NULL all markers in \code{db} will be used.}

\item{db}{data.frame with the allele frequency database (if random profiles are simulated).}

\item{fixed.profile}{data.frame with columns 'Marker' and 'Allele' (if fixed profiles are simulated).}

\item{sim}{integer the number of simulations per calibration cycle.}

\item{pcr.cyc}{integer the number of PCR cycles.}

\item{ce.aliq}{integer the aliquot PCR product used for capillary electrophoresis.}

\item{pcr.aliq}{integer the aliquot DNA extract transferred to the PCR reaction.}

\item{pcr.vol}{integer the total PCR reaction volume.}

\item{minimize}{logical \code{TRUE} stops when the squared difference is minimized,
\code{FALSE} continues until the PCR efficiency is 0.}

\item{step.size}{numeric size of PCR efficiency reduction for each calibration cycle.}

\item{cell.dna}{numeric the DNA content of a diploid cell in nanograms (default is 0.006 ng).}

\item{dna.amount}{numeric the amount of DNA in nanograms (ng) to be used in simulation.
NB! must correspond to the amount in samples used to calculate \code{target}.}

\item{filter}{logical \code{TRUE} to retrieve known alleles defined in \code{ref} from \code{data}.}

\item{plot.data}{logical to show linear regression data plot with marked target.}

\item{decimals}{interger for number of decimal places in plot title.}

\item{debug}{logical to print debug information.}

\item{ext.debug}{logical to print extended debug information.}
}
\description{
Estimates the detection threshold, peak height scaling factor,
and PCR efficiency needed to calibrate PCRsim.
}
\details{
To calibrate the PCR simulator perform the following experiments:
1) Prepare single source samples with optimal amount of DNA (different or replicates)
Calculate the average total peak height (sum of peak heights) across all samples
to set the \code{target} parameter.
2) Prepare a serial dilution (preferrably from intact cells, or from single
source crime scene samples). It is suitable to go from approximately optimal amount
down to low concentrations with drop-outs or completely blank profiles.
Quantify each dilution as accurately as possible. Amplify using normal 
procedure and analyse the PCR product.
Require a dataset with sample names ('Sample.Name'), and (average) concentration or
(average) amount in columns named 'Concentration' and 'Amount' respectively. Also
requires the average peak height ('H').

NB! Samples with either zero average peak height or zero number of molecules is removed automatically.
In addition, if replicate quants, samples where one replicate was negative can be removed manually.
}
