% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{pdf_info}
\alias{pdf_info}
\alias{pdftools}
\alias{pdf_text}
\alias{pdf_fonts}
\alias{pdf_attachments}
\alias{pdf_toc}
\title{PDF utilities}
\usage{
pdf_info(pdf, opw = "", upw = "")

pdf_text(pdf, opw = "", upw = "")

pdf_fonts(pdf, opw = "", upw = "")

pdf_attachments(pdf, opw = "", upw = "")

pdf_toc(pdf, opw = "", upw = "")
}
\arguments{
\item{pdf}{file path or raw vector with pdf data}

\item{opw}{string with owner password to open pdf}

\item{upw}{string with user password to open pdf}
}
\description{
Utilities based on libpoppler for extracting text, fonts, attachments
and metadata from a pdf file.
}
\details{
Poppler is pretty verbose when encountering minor errors in PDF files,
in especially \code{\link{pdf_text}}. These messages are usually safe
to ignore, use \code{\link{suppressMessages}} to hide them alltogether.
}
\examples{
# Just a random pdf file
pdf_file <- file.path(R.home("doc"), "NEWS.pdf")
info <- pdf_info(pdf_file)
text <- pdf_text(pdf_file)
fonts <- pdf_fonts(pdf_file)
files <- pdf_attachments(pdf_file)
}
\seealso{
Other pdftools: \code{\link{pdf_render_page}}
}
