% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotPartial.R
\name{plotPartial}
\alias{plotPartial}
\alias{plotPartial.ice}
\alias{plotPartial.cice}
\alias{plotPartial.partial}
\title{Plotting Partial Dependence Functions}
\usage{
plotPartial(object, ...)

\method{plotPartial}{ice}(object, center = FALSE, plot.pdp = TRUE,
  pdp.col = "red2", pdp.lwd = 2, pdp.lty = 1, rug = FALSE,
  train = NULL, alpha = 1, ...)

\method{plotPartial}{cice}(object, plot.pdp = TRUE, pdp.col = "red2",
  pdp.lwd = 2, pdp.lty = 1, rug = FALSE, train = NULL, alpha = 1,
  ...)

\method{plotPartial}{partial}(object, center = FALSE, plot.pdp = TRUE,
  pdp.col = "red2", pdp.lwd = 2, pdp.lty = 1, smooth = FALSE,
  rug = FALSE, chull = FALSE, levelplot = TRUE, contour = FALSE,
  contour.color = "white", col.regions = NULL, palette = c("viridis",
  "magma", "inferno", "plasma", "cividis"), alpha = 1, number = 4,
  overlap = 0.1, train = NULL, ...)
}
\arguments{
\item{object}{An object that inherits from the \code{"partial"} class.}

\item{...}{Additional optional arguments to be passed onto \code{dotplot},
\code{levelplot}, \code{xyplot}, or \code{wireframe}.}

\item{center}{Logical indicating whether or not to produce centered ICE
curves (c-ICE curves). Only useful when \code{object} represents a set of ICE
curves; see \code{\link[pdp]{partial}} for details. Default is \code{FALSE}.}

\item{plot.pdp}{Logical indicating whether or not to plot the partial
dependence function on top of the ICE curves. Default is \code{TRUE}.}

\item{pdp.col}{Character string specifying the color to use for the partial
dependence function when \code{plot.pdp = TRUE}. Default is \code{"red"}.}

\item{pdp.lwd}{Integer specifying the line width to use for the partial
dependence function when \code{plot.pdp = TRUE}. Default is \code{1}. See
\code{\link[graphics]{par}} for more details.}

\item{pdp.lty}{Integer or character string specifying the line type to use
for the partial dependence function when  \code{plot.pdp = TRUE}. Default is
\code{1}. See \code{\link[graphics]{par}} for more details.}

\item{rug}{Logical indicating whether or not to include rug marks on the
predictor axes. Default is \code{FALSE}.}

\item{train}{Data frame containing the original training data. Only required
if \code{rug = TRUE} or \code{chull = TRUE}.}

\item{alpha}{Numeric value in \code{[0, 1]} specifying the opacity alpha (
most useful when plotting ICE/c-ICE curves). Default is 1 (i.e., no
transparency).}

\item{smooth}{Logical indicating whether or not to overlay a LOESS smooth.
Default is \code{FALSE}.}

\item{chull}{Logical indicating whether or not to restrict the first two
variables in \code{pred.var} to lie within the convex hull of their training
values; this affects \code{pred.grid}. Default is \code{FALSE}.}

\item{levelplot}{Logical indicating whether or not to use a false color level
plot (\code{TRUE}) or a 3-D surface (\code{FALSE}). Default is \code{TRUE}.}

\item{contour}{Logical indicating whether or not to add contour lines to the
level plot. Only used when \code{levelplot = TRUE}. Default is \code{FALSE}.}

\item{contour.color}{Character string specifying the color to use for the
contour lines when \code{contour = TRUE}. Default is \code{"white"}.}

\item{col.regions}{Color vector to be used for trivariate displays. If
\code{levelplot} is \code{TRUE}, defaults to the wonderful Matplotlib
'viridis' color map provided by the \code{viridis} package. See
\code{\link[viridis]{viridis}} for details.}

\item{palette}{Character string indicating the colormap option to use. Five
options are available: "viridis" (the default), "magma", "inferno", "plasma",
and "cividis".}

\item{number}{Integer specifying the number of conditional intervals to use
for the continuous panel variables. See \code{\link[graphics]{co.intervals}}
and \code{\link[lattice]{equal.count}} for further details.}

\item{overlap}{The fraction of overlap of the conditioning variables. See
\code{\link[graphics]{co.intervals}} and \code{\link[lattice]{equal.count}}
for further details.}
}
\description{
Plots partial dependence functions (i.e., marginal effects) using
\code{\link[lattice]{lattice}} graphics.
}
\examples{
\dontrun{
#
# Regression example (requires randomForest package to run)
#

# Load required packages
library(ggplot2)  # required to use autoplot
library(randomForest)

# Fit a random forest to the Boston housing data
data (boston)  # load the boston housing data
set.seed(101)  # for reproducibility
boston.rf <- randomForest(cmedv ~ ., data = boston)

# Partial dependence of cmedv on lstat
boston.rf \%>\%
  partial(pred.var = "lstat") \%>\%
  plotPartial(rug = TRUE, train = boston)

# Partial dependence of cmedv on lstat and rm
boston.rf \%>\%
  partial(pred.var = c("lstat", "rm"), chull = TRUE, progress = "text") \%>\%
  plotPartial(contour = TRUE, legend.title = "rm")

# ICE curves and c-ICE curves
age.ice <- partial(boston.rf, pred.var = "lstat", ice = TRUE)
p1 <- plotPartial(age.ice, alpha = 0.5)
p2 <- plotPartial(age.ice, center = TRUE, alpha = 0.5)
grid.arrange(p1, p2, ncol = 2)
}
}
