% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_separation.R
\name{summ_separation}
\alias{summ_separation}
\title{Summarize distributions with separation threshold}
\usage{
summ_separation(f, g, method = "KS", n_grid = 10001)
}
\arguments{
\item{f}{A pdqr-function of any \link[=meta_type]{type} and
\link[=meta_class]{class}. Represents "true" distribution of "negative" values.}

\item{g}{A pdqr-function of any type and class. Represents "true"
distribution of "positive" values.}

\item{method}{Separation method. Should be one of "KS" (Kolmogorov-Smirnov),
"GM", "OP", "F1", "MCC" (all four are methods for computing classification
metric in \code{\link[=summ_classmetric]{summ_classmetric()}}).}

\item{n_grid}{Number of grid points to be used during optimization.}
}
\value{
A single number representing optimal separation threshold.
}
\description{
Compute for pair of pdqr-functions the optimal threshold that separates
distributions they represent. In other words, \code{summ_separation()} solves a
binary classification problem with one-dimensional linear classifier: values
not more than some threshold are classified as one class, and more than
threshold - as another. Order of input functions doesn't matter.
}
\details{
All methods:
\itemize{
\item Return middle point of nearest support edges in case of non-overlapping or
"touching" supports of \code{f} and \code{g}.
\item Return the smallest optimal solution in case of several candidates.
}

Method "KS" computes "x" value at which corresponding p-functions of \code{f} and
\code{g} achieve supremum of their absolute difference (so input order of \code{f} and
\code{g} doesn't matter). If input pdqr-functions have the same
\link[=meta_type]{type}, then result is a point of maximum absolute difference.
If inputs have different types, then absolute difference of p-functions at
the result point can be not the biggest. In that case output represents a
left limit of points at which target supremum is reached (see Examples).

Methods "GM", "OP", "F1", "MCC" compute threshold which maximizes
corresponding \link[=summ_classmetric]{classification metric} for best suited
classification setup. They evaluate metrics at equidistant grid (with
\code{n_grid} elements) for both directions (\verb{summ_classmetric(f, g, *)} and
\verb{summ_classmetric(g, f, *)}) and return threshold which results into maximum
of both setups. \strong{Note} that other \code{summ_classmetric()} methods are either
useless here (always return one of the edges) or are equivalent to ones
already present.
}
\examples{
d_norm_1 <- as_d(dnorm)
d_unif <- as_d(dunif)
summ_separation(d_norm_1, d_unif, method = "KS")
summ_separation(d_norm_1, d_unif, method = "OP")

# Mixed types for "KS" method
p_dis <- new_p(1, "discrete")
p_unif <- as_p(punif)
thres <- summ_separation(p_dis, p_unif)
abs(p_dis(thres) - p_unif(thres))
  # Actual difference at `thres` is 0. However, supremum (equal to 1) as
  # limit value is # reached there.
x_grid <- seq(0, 1, by = 1e-3)
plot(x_grid, abs(p_dis(x_grid) - p_unif(x_grid)), type = "b")

# Handling of non-overlapping supports
summ_separation(new_d(2, "discrete"), new_d(3, "discrete"))

# The smallest "x" value is returned in case of several optimal thresholds
summ_separation(d_norm_1, d_norm_1) == meta_support(d_norm_1)[1]

}
\seealso{
\code{\link[=summ_roc]{summ_roc()}} for computing ROC curve related summaries.

\code{\link[=summ_classmetric]{summ_classmetric()}} for computing of classification metric for ordered
classification setup.

Other summary functions: 
\code{\link{summ_center}()},
\code{\link{summ_classmetric}()},
\code{\link{summ_distance}()},
\code{\link{summ_entropy}()},
\code{\link{summ_hdr}()},
\code{\link{summ_interval}()},
\code{\link{summ_moment}()},
\code{\link{summ_order}()},
\code{\link{summ_prob_true}()},
\code{\link{summ_pval}()},
\code{\link{summ_quantile}()},
\code{\link{summ_roc}()},
\code{\link{summ_spread}()}
}
\concept{summary functions}
