% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pdynmc_specTestFcst.R
\name{wald.fct}
\alias{wald.fct}
\title{Wald test.}
\usage{
wald.fct(param, object)
}
\arguments{
\item{param}{A character string that denotes the null hypothesis. Choices are
time.dum (i.e., all time dummies are jointly zero), slope (i.e., all slope
coefficients are jointly zero), and all (i.e., all dummies and slope
coefficients are jointly zero).}

\item{object}{An object of class `pdynmc`.}
}
\value{
An object of class `htest` which contains the F test statistic and
   corresponding p-value for the tested null hypothesis.
}
\description{
\code{wald.fct} computes F test statistics and corresponding p-values for
   `pdynmc` objects.
}
\details{
The three available null hypothesis are: All time dummies are zero jointly,
   all slope coefficients are zero jointly, all times dummies and slope
   coefficients are zero jointly.
}
\examples{
## Load data from plm package
data(EmplUK, package = "plm")
dat <- EmplUK
dat[,c(4:7)] <- log(dat[,c(4:7)])
dat <- dat[c(140:0), ]

## Code example
m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
   use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
   include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
   fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
   varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
   include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
   w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
   opt.meth = "none")
wald.fct(param = "all", m1)

\donttest{
## Load data from plm package
data(EmplUK, package = "plm")
dat <- EmplUK
dat[,c(4:7)] <- log(dat[,c(4:7)])

## Further code example
m1 <- pdynmc(dat = dat, varname.i = "firm", varname.t = "year",
   use.mc.diff = TRUE, use.mc.lev = FALSE, use.mc.nonlin = FALSE,
   include.y = TRUE, varname.y = "emp", lagTerms.y = 2,
   fur.con = TRUE, fur.con.diff = TRUE, fur.con.lev = FALSE,
   varname.reg.fur = c("wage", "capital", "output"), lagTerms.reg.fur = c(1,2,2),
   include.dum = TRUE, dum.diff = TRUE, dum.lev = FALSE, varname.dum = "year",
   w.mat = "iid.err", std.err = "corrected", estimation = "onestep",
   opt.meth = "none")
wald.fct(param = "all", m1)
}


}
\seealso{
\code{\link{pdynmc}} for fitting a linear dynamic panel data model.
}
