% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_peace_years.R
\name{add_peace_years}
\alias{add_peace_years}
\title{Add Peace Years to Your Conflict Data}
\usage{
add_peace_years(data, pad = FALSE)
}
\arguments{
\item{data}{a dyad-year data frame (either "directed" or "non-directed")}

\item{pad}{an optional parameter, defaults to FALSE. If TRUE, the peace-year calculations fill in cases where panels are
unbalanced/have gaps. Think of a state like Germany disappearing for 45 years as illustrative of this.

If \code{keep} is not specified in the function, the ensuing output returns everything.}
}
\value{
\code{add_peace_years()} takes a dyad-year data frame and adds peace years for ongoing dyadic conflicts.
}
\description{
\code{add_peace_years()} calculates peace years for your ongoing dyadic conflicts. The function
works for both the CoW-MID data and the Gibler-Miller-Little (GML) MID data.
}
\details{
The function internally uses \code{sbtscs()} from \pkg{stevemisc}. In the interest of full disclosure,
\code{sbtscs()} leans heavily on \code{btscs()} from \pkg{DAMisc}. I optimized some code for performance.
}
\examples{

\donttest{
# just call `library(tidyverse)` at the top of the your script
library(magrittr)
cow_ddy \%>\%
add_gml_mids(keep = NULL) \%>\%
add_cow_mids(keep = NULL) \%>\%
add_contiguity() \%>\%
add_cow_majors() \%>\%
filter_prd()  \%>\%
add_peace_years()
}

}
\references{


Armstrong, Dave. 2016. ``\pkg{DAMisc}: Dave Armstrong's Miscellaneous Functions.''
\emph{R package version 1.4-3}.

Miller, Steven V. 2017. ``Quickly Create Peace Years for BTSCS Models with \code{sbtscs} in \code{stevemisc}.''
\url{http://svmiller.com/blog/2017/06/quickly-create-peace-years-for-btscs-models-with-stevemisc/}
}
\author{
Steven V. Miller
}
