% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutationModel.R
\name{mutationModel}
\alias{mutationModel}
\alias{validateMutationModel}
\alias{sexEqual}
\title{Mutation models}
\usage{
mutationModel(
  model,
  alleles = NULL,
  afreq = NULL,
  matrix = NULL,
  rate = NULL,
  rate2 = NULL,
  range = NULL,
  seed = NULL,
  transform = NULL,
  validate = TRUE
)

validateMutationModel(mutmod, alleles = NULL)

sexEqual(mutmod)
}
\arguments{
\item{model}{Either:
\itemize{
\item a \code{mutationModel} object (returned unchanged after validation)
\item a single \code{mutationMatrix} object (will be applied to both genders)
\item a list of two \code{mutationMatrix} objects, named "female" and "male"
\item a single model name (see \code{\link[=mutationMatrix]{mutationMatrix()}} for valid options)
\item a list of two model names, named "female" and "male"
}}

\item{alleles}{A character vector with allele labels; passed on to
\code{\link[=mutationMatrix]{mutationMatrix()}}.}

\item{afreq}{A numeric vector of allele frequencies; passed on to
\code{\link[=mutationMatrix]{mutationMatrix()}}.}

\item{matrix}{A matrix, or a list of two (named "female" and "male")}

\item{rate}{A numeric mutation rate, or a list of two (named "female" and
"male")}

\item{rate2}{A numeric mutation rate, or a list of two (named "female" and
"male"). Required in the "stepwise" model; see \code{\link[=mutationMatrix]{mutationMatrix()}} for
details.}

\item{range}{A positive number, or a list of two (named "female" and "male").
Required in the "stepwise" model; see \code{\link[=mutationMatrix]{mutationMatrix()}} for details.}

\item{seed}{An integer, or a list of two (named "female" and "male").}

\item{transform}{Either NULL (default) or the name of a transformation to be
applied to the mutation model. See \code{\link[=makeReversible]{makeReversible()}}.}

\item{validate}{A logical, by default TRUE.}

\item{mutmod}{A \code{mutationModel} object.}
}
\value{
An object of class \code{mutationModel}. This is a list of two
\code{mutationMatrix} objects, named "female" and "male", and the following
attributes:
\itemize{
\item \code{sexEqual} : TRUE if both genders have identical models, otherwise FALSE
\item \code{alwaysLumpable} : TRUE if both genders have models that are lumpable for
any allele subset, otherwise FALSE
}
}
\description{
Constructor for the class \code{mutationModel}. An object of this class is
essentially a list of two mutation matrices, named "female" and "male".
}
\examples{
# "Equal" model, same parameters for both genders
M1 = mutationModel("eq", alleles = 1:2, rate = 0.1)
M1

# Different mutation rates
M2 = mutationModel("eq", alleles = 1:2, rate = list(male = 0.1, female = 0.01))
M2

stopifnot(identical(M1$male, M1$female), identical(M2$male, M1$male))

# A custom mutation matrix:
mat = matrix(c(0,0,1,1), ncol = 2, dimnames = list(1:2, 1:2))
M3 = mutationModel(model = "custom", matrix = mat)

# Under the hood arguments are passed to `mutationMatrix()`.
# Alternatively, this can be done explicitly in the `model` argument
M4 = mutationModel(model = mutationMatrix("custom", matrix = mat))

stopifnot(identical(M3, M4))

# The latter strategy is needed e.g. in pedtools::marker(), which gives the
# user access to `model`, but not `matrix`.

}
