% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/twoMarkerDistribution.R
\name{twoMarkerDistribution}
\alias{twoMarkerDistribution}
\title{Genotype distribution for two linked markers}
\usage{
twoMarkerDistribution(
  x,
  id,
  marker1 = 1,
  marker2 = 2,
  rho = NULL,
  loopBreakers = NULL,
  partialmarker1 = NULL,
  partialmarker2 = NULL,
  verbose = TRUE
)
}
\arguments{
\item{x}{A \code{ped} object or a list of such.}

\item{id}{A single ID label.}

\item{marker1, marker2}{Either \code{marker} objects, or the names (or indices) of
markers attached to \code{x}.}

\item{rho}{A single numeric in the interval \verb{[0, 0.5]}: the recombination
fraction between the two markers.}

\item{loopBreakers}{(Only relevant if the pedigree has loops). A vector with
ID labels of individuals to be used as loop breakers. If NULL (default)
loop breakers are selected automatically. See \code{\link[pedtools:inbreedingLoops]{pedtools::breakLoops()}}.}

\item{partialmarker1, partialmarker2}{(Deprecated) Aliases for \code{marker1} and
\code{marker2}.}

\item{verbose}{A logical.}
}
\value{
A named matrix giving the joint genotype distribution.
}
\description{
Computes the joint genotype distribution of two markers for a specified
pedigree member, conditional on known genotypes and the recombination rate
between the markers.
}
\examples{

# A sib-pair with two SNPs. The first child is homozygous 1/1.
x = nuclearPed(children = c("bro1", "bro2")) |>
  addMarker(bro1 = "1/1", alleles = 1:2, afreq = c(0.5, 0.5)) |>
  addMarker(bro1 = "1/1", alleles = 1:2, afreq = c(0.5, 0.5))

plot(x, marker = 1:2)

# Genotype distribution for the brother depends on linkage
twoMarkerDistribution(x, id = "bro2", rho = 0)
twoMarkerDistribution(x, id = "bro2", rho = 0.5)

### Same example on X
y = setChrom(x, marker = 1:2, chrom = "X")

plot(y, marker = 1:2)

twoMarkerDistribution(y, id = "bro2", rho = 0)
twoMarkerDistribution(y, id = "bro2", rho = 0.5)

}
\seealso{
\code{\link[=oneMarkerDistribution]{oneMarkerDistribution()}}
}
