% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker_setattr.R
\name{marker_setattr}
\alias{marker_setattr}
\alias{setGenotype}
\alias{setAfreq}
\alias{setAlleleLabels}
\alias{setMarkername}
\alias{setChrom}
\alias{setPosition}
\title{Set marker attributes}
\usage{
setGenotype(x, marker = NULL, ids = NULL, geno = NULL, id = NULL)

setAfreq(x, marker, afreq, strict = TRUE)

setAlleleLabels(x, marker, alleles)

setMarkername(x, marker = NULL, name)

setChrom(x, marker = NULL, chrom)

setPosition(x, marker = NULL, posMb)
}
\arguments{
\item{x}{A \code{ped} object or a list of \code{ped} objects.}

\item{marker}{A vector of indices or names of one or several markers attached
to \code{x}.}

\item{geno}{A character vector of length \code{pedsize(x)}, with genotypes written
in the format "a/b".}

\item{id, ids}{A vector naming one or several pedigree members, or a function
(e.g., \code{\link[=founders]{founders()}}).}

\item{afreq}{A numeric of the same length as \code{alleles}, indicating the
population frequency of each allele. A warning is issued if the frequencies
don't sum to 1 after rounding to 3 decimals. If the vector is named, and
\code{alleles} is not NULL, an error is raised if \code{setequal(names(afreq), alleles)} is not TRUE. If \code{afreq} is not specified, all alleles are given
equal frequencies.}

\item{strict}{A logical. If TRUE (default) the new frequencies cannot remove
or add any alleles.}

\item{alleles}{A vector of allele names. If not given, and \code{afreq} is named,
\code{names(afreq)} is used. Otherwise, the default action is to use all
distinct alleles occurring in \code{allelematrix}, \code{geno} or \code{...}.}

\item{name}{A character of the same length as \code{marker}, containing marker
names.}

\item{chrom}{A character of the same length as \code{marker}, containing
chromosome labels.}

\item{posMb}{A numeric of the same length as \code{marker}, containing the
physical marker positions in megabases (or NA).}
}
\value{
A copy of \code{x} with modified attributes.
}
\description{
These functions set or modify various attributes of markers attached to a
pedigree. They are sometimes more convenient (and pipe-friendly) than the
in-place modifiers described in \link{marker_inplace}.
}
\examples{
x = nuclearPed() |>
  addMarker(alleles = 1:2) |>
  setMarkername(marker = 1, name = "M") |>
  setGenotype(marker = "M", ids = 1, geno = "1/2") |>
  setAfreq(marker = "M", afreq = c(`1` = 0.1, `2` = 0.9)) |>
  setChrom(marker = "M", chrom = 1) |>
  setPosition(marker = "M", posMb = 123.45)

# Alternatively, all of this could have been done on creation:
y = addMarker(nuclearPed(),
              `1` = "1/2",
              afreq = c(`1` = 0.1, `2` = 0.9),
              name = "M",
              chrom = 1,
              posMb = 123.45)
stopifnot(identical(x, y))

}
