% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.PHcure.R
\name{predict.PHcure}
\alias{predict.PHcure}
\title{Predict method for PHcure.object}
\usage{
\method{predict}{PHcure}(object, newdata, X = NULL,...)
}
\arguments{
\item{object}{an object of class \code{\link{PHcure.object}}.}

\item{newdata}{a data.frame in counting process format.}

\item{X}{[optional] a matrix of time-invariant covariates. It is not required, unless argument \code{X} was supplied in the call to the \code{\link{penPHcure}} function.}

\item{...}{ellipsis to pass extra arguments.}
}
\value{
An object of class \code{predict.PHcure}, a list including the following elements:
\item{\code{CURE}}{a numeric vector containing the probabilities to be susceptible to the event of interest: \deqn{P(Y_i=1|x_i) = \frac{ e^{\mathbf{x}_i'\hat{\mathbf{b}}}   }{1+e^{\mathbf{x}_i'\hat{\mathbf{b}}}},} where \eqn{\mathbf{x}_i} is a vector of time-invariant covariates and \eqn{\hat{\mathbf{b}}} is a vector of estimated coefficients.}
\item{\code{SURV}}{a numeric vector containing the survival probabilities (conditional on being susceptible to the event of interest): \deqn{S(t_i|Y_i=1,\bar{\mathbf{z}}_i(t))=\exp\left(-\sum_{j=1}^K (t_{(j-1)}-t_{(j)}) \hat{\lambda}_{0j} I(t_{(j)}\leq t_i) e^{\mathbf{z}_i(t_{(j)})\hat{\boldsymbol{\beta}}}\right),} where \eqn{t_{(1)}<t_{(2)}<...<t_{(K)}} denotes the \eqn{K} ordered event-times, \eqn{\mathbf{z}_i(t)} is a vector of time-varying covariates, \eqn{\hat{\boldsymbol{\beta}}} is a vector of estimated coefficients and \eqn{\hat{\lambda}_{0j}} is the estimated baseline hazard function (constant in the interval \eqn{(t_{(j-1)},t_{(j)}]}). }
}
\description{
Compute probabilities to be susceptible and survival probabilities (conditional on being susceptible) for a model fitted by \code{\link{penPHcure}} with the argument \code{pen.type = "none"}.
}
\details{
If argument \code{X} was not supplied in the call to the \code{\link{penPHcure}} function, the probabilities to be susceptible are computed using the covariates retrieved using the same \code{which.X} method as in the \code{\link{penPHcure}} function call.
}
\examples{
# Generate some data (for more details type ?penPHcure.simulate in your console)
set.seed(12) # For reproducibility
data <- penPHcure.simulate(N=250)
 
# Fit standard cure model (without inference)
fit <- penPHcure(Surv(time = tstart,time2 = tstop,
                      event = status) ~ z.1 + z.2 + z.3 + z.4,
                 cureform = ~ x.1 + x.2 + x.3 + x.4,data = data)

# Use the predict method to obtain the probabilities for the fitted model
pred.fit <- predict(fit,data)

# Use the predict method to make prediction for new observations.
#  For example, two individuals censored at time 0.5 and 1.2, respectively,
#  and all cavariates equal to 1.
newdata <- data.frame(tstart=c(0,0),tstop=c(0.5,1.2),status=c(0,0),
                      z.1=c(1,1),z.2=c(1,1),z.3=c(1,1),z.4=c(1,1),
                      x.1=c(1,1),x.2=c(1,1),x.3=c(1,1),x.4=c(1,1))
pred.fit.newdata <- predict(fit,newdata)
# The probabilities to be susceptible are:
pred.fit.newdata$CURE
# [1] 0.6761677 0.6761677
# The survival probabilities (conditional on being susceptible) are:
pred.fit.newdata$SURV
# [1] 0.5591570 0.1379086


}
