% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{Root Mean Squared Error of Linear Models}
\usage{
rmse(model, normalized = FALSE)
}
\arguments{
\item{model}{Linear model of class \code{lm}, \code{merMod} (\pkg{lme4})
or \code{lme} (\pkg{nlme}).}

\item{normalized}{Logical, use \code{TRUE} if normalized rmse should be returned.}
}
\value{
Numeric, the root mean squared error.
}
\description{
Compute root mean squared error for linear (mixed effects) models.
}
\details{
The RMSE is the square root of the variance of the residuals and indicates
  the absolute fit of the model to the data (difference between observed data
  to model's predicted values). It can be interpreted as the standard
  deviation of the unexplained variance, and is in the same units as the
  response variable. Lower values indicate better model fit.
  \cr \cr
  The normalized RMSE is the proportion of the RMSE related to the
  range of the response variable. Hence, lower values indicate
  less residual variance.
}
\examples{
library(nlme)
m <- lme(distance ~ age, data = Orthodont)

# RMSE
rmse(m, normalized = TRUE)

# normalized RMSE
rmse(m, normalized = TRUE)

}
