# -------------------------------------------------
# --              FRAMEWORK server.R             --
# -------------------------------------------------
# NOTES:                                         --
# Program code goes in "program" directory files --
# -------------------------------------------------
# *****        DO NOT EDIT THIS FILE       ***** --
# -------------------------------------------------

source(paste("program", "server_global.R", sep = .Platform$file.sep),
       local = TRUE)


shinyServer(function(input, output, session) {
    ss_userAction.Log <- periscope2:::fw_get_user_log()

    source(paste("program", "server_local.R", sep = .Platform$file.sep),
           local = TRUE)

    periscope2:::fw_server_setup(input            = input,
                                 output           = output,
                                 session          = session,
                                 logger           = ss_userAction.Log,
                                 logger_viewer_id = "logViewerId")

    announce_close_time <- periscope2:::load_announcements()
    if (!is.null(announce_close_time)) {
        shinyjs::delay(announce_close_time,{
            bs4Dash::closeAlert("announceAlert")
        })
    }

    loginfo("%s started with log level <%s>",
            periscope2:::fw_get_title(), periscope2:::fw_get_loglevel(),
            logger = ss_userAction.Log)

    # Display application info
    observeEvent(input$app_info, {
        show_alert(html                = TRUE,
                   showConfirmButton   = FALSE,
                   btn_labels          = NA,
                   width               = "60%",
                   showCancelButton    = FALSE,
                   showCloseButton     = TRUE,
                   animation           = "slide-from-top",
                   closeOnClickOutside = TRUE,
                   text                = periscope2:::.g_opts$app_info,
                   title               = periscope2:::.g_opts$app_title)
    })
})
