% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/that_for.R
\name{sets}
\alias{sets}
\alias{that_for_all}
\alias{that_for_any}
\alias{we_have}
\title{R Set Comprehension}
\usage{
that_for_all(.x, .y)

that_for_any(.x, .y)

we_have(that_for, formula, result = "vector")
}
\arguments{
\item{.x}{A set, represented as either an atomic vector or a list}

\item{.y}{A set to compare to \code{.x}}

\item{that_for}{A list passed to \code{we_have}--can be ignored with proper syntax}

\item{formula}{A boolean-valued function, lambda, or formula}

\item{result}{Should the expression return a \code{vector} or an \code{Iterator}?}
}
\value{
For \code{that_for_all} and \code{that_for_any}, an object of S3 class that_for_all or that_for_any.
For we_have, a vector of the same type as \code{.x} if \code{return == 'vector'} and an Iterator object if \code{return == 'Iterator'}.
}
\description{
Set comprehension with the Magrittr Pipe.
Always use the syntax:
\code{.x \%>\% that_for_all(.y) \%>\% we_have_*(f(.x, .y))}.
}
\details{
This function is designed to be used with \code{\%>\%} from \code{magrittr}.
Essentially, this function evaluates \code{f \%>\% g()} as
\code{eval(g(f), envir = new.env(parent = parent.frame())}. Any pipe or pipe-like
function that works similarly should work with \code{that_for_*}. In particular,
the R Core Team is expected to implement a base R pipe in the near future with
the syntax \code{|>}. While these functions will likely work properly with the new
\code{|>}, as of right now the only pipe that is guaranteed to work is
\code{\%>\%}.
}
\note{
if .y is an numeric vector, you probably want a value obtained from
\code{peruse::range(start, end)} rather than \code{start:end} or \code{seq(start,end)}, as when
start is greater than end you want an empty vector rather than counting backwards.
Note that \code{peruse::range} views end as a supremum, not a maximum, thus \code{range(a,b)}
is equivalent to the set \code{[}a,b) when a < b or \code{{}} when b >= a.
}
\examples{
library(magrittr)
2:100 \%>\% that_for_all(range(2, .x)) \%>\% we_have(function(.x, .y) .x \%\% .y != 0) #is the same as
2:100 \%>\% that_for_all(range(2, .x)) \%>\% we_have(~.x \%\% .y != 0)
#c.f.
primes <- 2:100 \%>\% that_for_all(range(2, .x)) \%>\% we_have(~.x \%\% .y != 0, "Iterator")
yield_next(primes)
{c("I", "Don't", "wan't", "chicken") \%>\%
             that_for_all("\'") \%>\%
             we_have(~grepl(.y, .x))}
#Twin primes 1 through 100
\dontrun{
primes <- 2:100 \%>\% that_for_all(range(2, .x)) \%>\% we_have(~.x \%\% .y != 0)
primes \%>\% that_for_any(primes) \%>\% we_have(~abs(.x - .y) == 2)
#Prime numbers 1 through 100 that are two away from a square number
}
(2:100 \%>\% that_for_all(range(2, .x)) \%>\% we_have(~.x \%\% .y != 0)) \%>\%
    that_for_any(range(2, .x)) \%>\% we_have(~sqrt(.x + 2) == .y | sqrt(.x - 2) == .y)

}
