% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{TRUNCATE}
\alias{TRUNCATE}
\title{Generate a postgreSQL TRUNCATE statement, optionally execute the statement if con is not NULL.}
\usage{
TRUNCATE(
  schema = NULL,
  table,
  restart_identity = FALSE,
  continue_identity = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{schema}{A string, the schema name of the SQL table to TRUNCATE.}

\item{table}{A string, the table name of the SQL table to TRUNCATE.}

\item{restart_identity}{TRUE/FALSE, if TRUE, will add RESTART IDENTITY to the statement.}

\item{continue_identity}{TRUE/FALSE, if TRUE, will add CONTINUE IDENTITY to the statement.}

\item{cascade}{TRUE/FALSE, if TRUE, will add CASCADE to the statement.}

\item{restrict}{TRUE/FALSE, if TRUE, will add RESTRICT to the statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL DELETE statement; or the results retrieved by DBI::dbGetQuery after executing the statement.
}
\description{
Generate a postgreSQL TRUNCATE statement, optionally execute the statement if con is not NULL.
}
\examples{
TRUNCATE(
schema = "test",
table = "table1"
)
}
