% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_combined_error_model}
\alias{set_combined_error_model}
\title{set_combined_error_model}
\usage{
set_combined_error_model(model, data_trans = NULL)
}
\arguments{
\item{model}{(Model) Set error model for this model}

\item{data_trans}{(str or expression) A data transformation expression or NULL (default) to use the transformation
specified by the model.}
}
\value{
(Model) Reference to the same model
}
\description{
Set a combined error model. Initial estimates for new sigmas are :math:\verb{(min(DV)/2)²} for
proportional and 0.09 for additive.

The error function being applied depends on the data transformation.

+------------------------+-----------------------------------------------------+
| Data transformation    | Combined error                                      |
+========================+=====================================================+
| :math:\code{y}              | :math:\verb{f + f epsilon_1 + epsilon_2}               |
+------------------------+-----------------------------------------------------+
| :math:\code{log(y)}         | :math:\verb{log(f) + epsilon_1 + frac\{epsilon_2\}\{f\}} |
+------------------------+-----------------------------------------------------+
}
\examples{
\dontrun{
model <- remove_error_model(load_example_model("pheno"))
set_combined_error_model(model)
model$statements$find_assignment("Y")
model <- remove_error_model(load_example_model("pheno"))
set_combined_error_model(model, data_trans="log(Y)")
model$statements$find_assignment("Y")
}
}
\seealso{
set_additive_error_model : Additive error model

set_proportional_error_model: Proportional error model
}
