% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{evaluate_expression}
\alias{evaluate_expression}
\title{evaluate_expression}
\usage{
evaluate_expression(model, expression, parameter_estimates = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{expression}{(str) Expression to evaluate}

\item{parameter_estimates}{(list(str=numeric) (optional)) Parameter estimates to use instead of initial estimates}
}
\value{
(data.frame) A series of one evaluated value for each data record
}
\description{
Evaluate expression using model

Calculate the value of expression for each data record.
The expression can contain dataset columns, variables in model and
population parameters. If the model has parameter estimates these
will be used. Initial estimates will be used for non-estimated parameters.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
pe <- results$parameter_estimates
evaluate_expression(model, "TVCL*1000", parameter_estimates=pe)
}

}
