% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{remove_loq_data}
\alias{remove_loq_data}
\title{remove_loq_data}
\usage{
remove_loq_data(
  model,
  lloq = NULL,
  uloq = NULL,
  blq = NULL,
  alq = NULL,
  keep = 0
)
}
\arguments{
\item{model}{(Model) Pharmpy model object}

\item{lloq}{(numeric or str (optional)) Value or column name for lower limit of quantification.}

\item{uloq}{(numeric or str (optional)) Value or column name for upper limit of quantification.}

\item{blq}{(str (optional)) Column name for below limit of quantification indicator.}

\item{alq}{(str (optional)) Column name for above limit of quantification indicator.}

\item{keep}{(numeric) Number of loq records to keep for each run of consecutive loq records.}
}
\value{
(Model) Pharmpy model object
}
\description{
Remove loq data records from the dataset

Does nothing if none of the limits are specified.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
model <- remove_loq_data(model, lloq=10, uloq=40)
length(model$dataset)
}
}
\seealso{
set_lloq_data

transform_blq
}
