% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/findEquilibrium.R
\name{findEquilibrium}
\alias{findEquilibrium}
\title{Equilibrium point identification}
\usage{
findEquilibrium(
  deriv,
  y0 = NULL,
  parameters = NULL,
  system = "two.dim",
  tol = 1e-16,
  max.iter = 50,
  h = 1e-06,
  plot.it = FALSE,
  summary = TRUE,
  state.names = if (system == "two.dim") c("x", "y") else "y"
)
}
\arguments{
\item{deriv}{A function computing the derivative at a point for the ODE
system to be analysed. Discussion of the required structure of these
functions can be found in the package vignette, or in the help file for the
function \code{\link[deSolve]{ode}}.}

\item{y0}{The starting point of the search. In the case of a one-dimensional
system, this should be a \code{\link[base]{numeric}}
\code{\link[base]{vector}} of \code{\link[base]{length}} one indicating the
location of the dependent variable initially. In the case of a
two-dimensional system, this should be a \code{\link[base]{numeric}}
\code{\link[base]{vector}} of \code{\link[base]{length}} two reflecting the
location of the two dependent variables initially. Alternatively this can be
specified as \code{\link[base]{NULL}}, and then
\code{\link[graphics]{locator}} can be used to specify the initial point on a
plot. Defaults to \code{\link[base]{NULL}}.}

\item{parameters}{Parameters of the ODE system, to be passed to \code{deriv}.
Supplied as a \code{\link[base]{numeric}} \code{\link[base]{vector}}; the
order of the parameters can be found from the \code{deriv} file. Defaults to
\code{NULL}.}

\item{system}{Set to either \code{"one.dim"} or \code{"two.dim"} to indicate
the type of system being analysed. Defaults to \code{"two.dim"}.}

\item{tol}{The tolerance for the convergence of the search algorithm.
Defaults to \code{1e-16}.}

\item{max.iter}{The maximum allowed number of iterations of the search
algorithm. Defaults to \code{50}.}

\item{h}{Step length used to approximate the derivative(s). Defaults to
\code{1e-6}.}

\item{plot.it}{Logical. If \code{TRUE}, a point is plotted at the identified
equilibrium point, with shape corresponding to its classification.}

\item{summary}{Set to either \code{TRUE} or \code{FALSE} to determine whether
a summary of the progress of the search procedure is returned. Defaults to
\code{TRUE}.}

\item{state.names}{The state names for \code{\link[deSolve]{ode}} functions
that do not use positional states.}
}
\value{
Returns a list with the following components (the exact make up is
dependent on the value of \code{system}):
\item{classification}{The classification of the identified equilibrium
point.}
\item{Delta}{In the two-dimensional system case, value of the Jacobian's
determinant at the equilibrium point.}
\item{deriv}{As per input.}
\item{discriminant}{In the one-dimensional system case, the value of the
discriminant used in perturbation analysis to assess stability. In the
two-dimensional system case, the value of \code{tr^2 - 4*Delta}.}
\item{eigenvalues}{In the two-dimensional system case, the value of the
Jacobian's eigenvalues at the equilibrium point.}
\item{eigenvectors}{In the two-dimensional system case, the value of the
Jacobian's eigenvectors at the equilibrium point.}
\item{jacobian}{In the two-dimensional system case, the Jacobian at the
equilibrium point.}
\item{h}{As per input.}
\item{max.iter}{As per input.}
\item{parameters}{As per input.}
\item{plot.it}{As per input.}
\item{summary}{As per input.}
\item{system}{As per input.}
\item{tr}{In the two-dimensional system case, the value of the Jacobian's
trace at the equilibrium point.}
\item{tol}{As per input.}
\item{y0}{As per input.}
\item{ystar}{The location of the identified equilibrium point.}
}
\description{
Searches for an equilibium point of a system, taking the starting point of
the search as a user specified location. On identifying such a point, a
classification is performed, and an informatively shaped point can be added
to the plot.
}
\author{
Michael J Grayling, Stephen P Ellner, John M Guckenheimer
}
