% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phate.R
\name{phate}
\alias{phate}
\title{Run PHATE on an input data matrix}
\usage{
phate(data, ndim = 2, k = 5, alpha = 40, n.landmark = 2000,
  gamma = 1, t = "auto", knn.dist.method = "euclidean",
  init = NULL, mds.method = "metric", mds.dist.method = "euclidean",
  t.max = 100, npca = 100, plot.optimal.t = FALSE, verbose = 1,
  n.jobs = 1, seed = NULL, potential.method = NULL,
  use.alpha = NULL, n.svd = NULL, pca.method = NULL,
  g.kernel = NULL, diff.op = NULL, landmark.transitions = NULL,
  diff.op.t = NULL, dist.method = NULL)
}
\arguments{
\item{data}{matrix (n_samples, n_dimensions)
2 dimensional input data array with
n_samples samples and n_dimensions dimensions.
If \code{knn.dist.method} is 'precomputed', \code{data} is treated as a
(n_samples, n_samples) distance or affinity matrix}

\item{ndim}{int, optional, default: 2
number of dimensions in which the data will be embedded}

\item{k}{int, optional, default: 5
number of nearest neighbors on which to build kernel}

\item{alpha}{int, optional, default: 40
sets decay rate of kernel tails.
If NULL, alpha decaying kernel is not used}

\item{n.landmark}{int, optional, default: 2000
number of landmarks to use in fast PHATE}

\item{gamma}{float, optional, default: 1
Informational distance constant between -1 and 1.
\code{gamma=1} gives the PHATE log potential, \code{gamma=0} gives
a square root potential.}

\item{t}{int, optional, default: 'auto'
power to which the diffusion operator is powered
sets the level of diffusion}

\item{knn.dist.method}{string, optional, default: 'euclidean'.
recommended values: 'euclidean', 'cosine', 'precomputed'
Any metric from \code{scipy.spatial.distance} can be used
distance metric for building kNN graph. If 'precomputed',
\code{data} should be an n_samples x n_samples distance or
affinity matrix. Distance matrices are assumed to have zeros
down the diagonal, while affinity matrices are assumed to have
non-zero values down the diagonal. This is detected automatically using
\code{data[0,0]}. You can override this detection with
\code{knn.dist.method='precomputed_distance'} or
\code{knn.dist.method='precomputed_affinity'}.}

\item{init}{phate object, optional
object to use for initialization. Avoids recomputing
intermediate steps if parameters are the same.}

\item{mds.method}{string, optional, default: 'metric'
choose from 'classic', 'metric', and 'nonmetric'
which MDS algorithm is used for dimensionality reduction}

\item{mds.dist.method}{string, optional, default: 'euclidean'
recommended values: 'euclidean' and 'cosine'}

\item{t.max}{int, optional, default: 100.
Maximum value of t to test for automatic t selection.}

\item{npca}{int, optional, default: 100
Number of principal components to use for calculating
neighborhoods. For extremely large datasets, using
n_pca < 20 allows neighborhoods to be calculated in
log(n_samples) time.}

\item{plot.optimal.t}{boolean, optional, default: FALSE
If TRUE, produce a plot showing the Von Neumann Entropy
curve for automatic t selection.}

\item{verbose}{\code{int} or \code{boolean}, optional (default : 1)
If \code{TRUE} or \code{> 0}, print verbose updates.}

\item{n.jobs}{\code{int}, optional (default: 1)
The number of jobs to use for the computation.
If -1 all CPUs are used. If 1 is given, no parallel computing code is
used at all, which is useful for debugging.
For n_jobs below -1, (n.cpus + 1 + n.jobs) are used. Thus for
n_jobs = -2, all CPUs but one are used}

\item{seed}{int or \code{NULL}, random state (default: \code{NULL})}

\item{potential.method}{Deprecated.
For log potential, use \code{gamma=1}. For sqrt potential, use \code{gamma=0}.}

\item{use.alpha}{Deprecated
To disable alpha decay, use \code{alpha=NULL}}

\item{n.svd}{Deprecated.}

\item{pca.method}{Deprecated.}

\item{g.kernel}{Deprecated.}

\item{diff.op}{Deprecated.}

\item{landmark.transitions}{Deprecated.}

\item{diff.op.t}{Deprecated.}

\item{dist.method}{Deprecated.}
}
\value{
"phate" object containing:
\itemize{
\item \strong{embedding}: the PHATE embedding
\item \strong{operator}: The PHATE operator (python phate.PHATE object)
\item \strong{params}: Parameters passed to phate
}
}
\description{
PHATE is a data reduction method specifically designed for visualizing
\strong{high} dimensional data in \strong{low} dimensional spaces.
}
\examples{
if (reticulate::py_module_available("phate")) {

# Load data
# data(tree.data)
# We use a smaller tree to make examples run faster
data(tree.data.small)

# Run PHATE
phate.tree <- phate(tree.data.small$data)
summary(phate.tree)
## PHATE embedding
## k = 5, alpha = 40, t = 58
## Data: (3000, 100)
## Embedding: (3000, 2)

library(graphics)
# Plot the result with base graphics
plot(phate.tree, col=tree.data.small$branches)
# Plot the result with ggplot2
if (require(ggplot2)) {
  ggplot(phate.tree) +
    geom_point(aes(x=PHATE1, y=PHATE2, color=tree.data.small$branches))
}

# Run PHATE again with different parameters
# We use the last run as initialization
phate.tree2 <- phate(tree.data.small$data, t=150, init=phate.tree)
# Extract the embedding matrix to use in downstream analysis
embedding <- as.matrix(phate.tree2)

}
}
