% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/D.R
\name{D}
\alias{D}
\alias{D1}
\alias{D2}
\alias{D1.fFIT}
\alias{D2.fFIT}
\alias{curvature}
\alias{curvature.fFIT}
\title{D}
\usage{
D1(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)

D2(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)

\method{D1}{fFIT}(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)

\method{D2}{fFIT}(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)

curvature(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)

\method{curvature}{fFIT}(fit, t = NULL, analytical = TRUE, smoothed.spline = FALSE, ...)
}
\arguments{
\item{fit}{A curve fitting object returned by \code{curvefit}, with the object of:
\itemize{
\item \code{par}: parameters of curve fitting function
\item \code{fun}: curve fitting function name, e.g., "doubleLog_AG"
\item \code{zs}: predicted values, vector or data.frame
}}

\item{analytical}{If true, \code{numDeriv} package \code{grad} and \code{hess}
will be used; if false, \code{D1} and \code{D2} will be used.}

\item{smoothed.spline}{Whether apply \code{smooth.spline} first?}

\item{...}{Other parameters will be ignored.}
}
\value{
\itemize{
\item der1 First order derivative
\item der2 Second order derivative
\item k    Curvature
}
}
\description{
Get derivative of \code{phenofit} object.
\code{D1} first order derivative, \code{D2} second order derivative, n
\code{curvature} curvature.
}
\details{
If \code{fit$fun} has no gradient function or \code{smoothed.spline = TRUE},
time-series smoothed by spline first, and get derivatives at last.
If \code{fit$fun} exists and \code{analytical = TRUE}, \code{smoothed.spline}
will be ignored.
}
\examples{
library(phenofit)
# simulate vegetation time-series
fFUN = doubleLog.Beck
par  = c(
    mn  = 0.1,
    mx  = 0.7,
    sos = 50,
    rsp = 0.1,
    eos = 250,
    rau = 0.1)
t    <- seq(1, 365, 8)
tout <- seq(1, 365, 1)
y <- fFUN(par, t)

methods <- c("AG", "Beck", "Elmore", "Gu", "Zhang") # "Klos" too slow
fFITs <- curvefit(y, t, tout, methods)
fFIT  <- fFITs$model$AG
d1 <- D1(fFIT)
d2 <- D2(fFIT)
d_k <- curvature(fFIT)
}
\keyword{internal}
