% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Tagloss_fit.R
\name{Tagloss_fit}
\alias{Tagloss_fit}
\title{fit a model of tag loss using a CMR database.}
\usage{

  Tagloss_fit(data = stop("A database formated using Tagloss_format() must be used"),
  fitted.parameters = NULL, fixed.parameters = NULL, model_before = NULL,
  model_after = NULL, control = list(trace = 1, maxit = 10000),
  method = "Nelder-Mead", lower = -Inf, upper = Inf, hessian = FALSE,
  cores = detectCores(all.tests = FALSE, logical = TRUE), groups = NULL)
}
\arguments{
\item{data}{An object formated using Tagloss_format}

\item{fitted.parameters}{Set of parameters to be fitted}

\item{fixed.parameters}{Set of fixed parameters}

\item{model_before}{Transformation of parameters before to use Tagloss_model()}

\item{model_after}{Transformation of parameters after to use Tagloss_model()}

\item{control}{Control parameters to be send to optim()}

\item{method}{optim() method}

\item{lower}{Lower value for parameter when Brent method is used}

\item{upper}{Upper value for parameter when Brent method is used}

\item{hessian}{Does the hessian matrix should be estimated}

\item{cores}{Number of cores to use for parallel computing}

\item{groups}{Number of groups for parallel computing}
}
\value{
Return a list object with the model describing tag loss.
}
\description{
This function fits a model of tag loss using a CMR database.\cr
The names of parameters can be:\cr
Left tag lost when 2 are present: D1_L2, D2D1_L2, D3D2_L2, A_L2, B_L2, C_L2, delta_L2\cr
Right tag lost when 2 are present: D1_R2, D2D1_R2, D3D2_R2, A_R2, B_R2, C_R2, delta_R2\cr
Left tag lost when 1 is present: D1_L1, D2D1_L1, D3D2_L1, A_L1, B_L1, C_L1, delta_L1\cr
Right tag lost when 1 is present: D1_R1, D2D1_R1, D3D2_R1, A_R1, B_R1, C_R1, delta_R1\cr
One tag lost when 2 are present: D1_2, D2D1_2, D3D2_2, A_2, B_2, C_2, delta_2\cr
One tag lost when 1 is present: D1_1, D2D1_1, D3D2_1, A_1, B_1, C_1, delta_1\cr
A, B and C are -logit(pA), -logit(pB) and -logit(pC) of the 
corresponding daily probabilities (p) of tag loss.\cr
delta is used as: p = p * invlogit(-delta)\cr
The use of delta parameter is complicated.\cr
Tag loss rate is pA at day 1\cr
Tag loss rate changes gradually from pA to pB that is reached at day D1\cr
Tag loss rate is pB from day D1 to day D2=D1+D2D1\cr
Tag loss rate changes gradually from pB to pC that is reached at day D2+D3D2\cr
If only one parameter is fitted, method must be "Brent" and upper and lower 
parameters must be set up with finite values.
}
\details{
Tagloss_fit fits a model of tag loss using a CMR database.
}
\examples{
\dontrun{
library(phenology)
# Example
data_f_21 <- Tagloss_format(outLR, model="21")
# Without the N20 the computing is much faster
data_f_21_fast <- subset(data_f_21, subset=(is.na(data_f_21$N20)))
par <- structure(c(48.8292784204825, 1039.02842229274, -89.3162940697861, 
5.21817463244988, 8.00575451188548, 8.32971268127933, 161.265553603601, 
602.935748681661, 2643.57415102633, 16.752815732218, 10.181616195839, 
7.14279063312016), .Names = c("D1_2", "D2D1_2", "D3D2_2", "A_2", 
"B_2", "C_2", "D1_1", "D2D1_1", "D3D2_1", "A_1", "B_1", "C_1"))
o <- Tagloss_fit(data=data_f_21_fast, fitted.parameters=par)
plot(o, model="1", col="red")
plot(o, model="2", col="blue", add=TRUE)
legend("topright", legend=c("2->1", "1->0"), lty=1, col=c("blue", "red"))
}
}
\seealso{
Other Model of Tag-loss: \code{\link{Tagloss_LengthObs}},
  \code{\link{Tagloss_L}}, \code{\link{Tagloss_daymax}},
  \code{\link{Tagloss_format}},
  \code{\link{Tagloss_model}},
  \code{\link{Tagloss_simulate}},
  \code{\link{logLik.Tagloss}}, \code{\link{plot.Tagloss}}
}
\author{
Marc Girondot
}
