% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_phenology.R
\name{fit_phenology}
\alias{fit_phenology}
\title{Fit the phenology parameters to timeseries of counts.}
\usage{
fit_phenology(data = file.choose(), fitted.parameters = NULL,
  fixed.parameters = NULL, method_incertitude = "convolution",
  infinite = 200, zero_counts = TRUE, store.intermediate = FALSE,
  file.intermediate = "Intermediate.rda", parallel = TRUE,
  hessian = TRUE, silent = FALSE, growlnotify = TRUE,
  cofactors = NULL, add.cofactors = NULL, zero = 1e-09, lower = 0,
  upper = Inf, control = list(trace = 1, REPORT = 1, maxit = 1000))
}
\arguments{
\item{data}{A dataset generated by add_format}

\item{fitted.parameters}{Set of parameters to be fitted}

\item{fixed.parameters}{Set of fixed parameters}

\item{method_incertitude}{'combinatory' estimates likelihood of all combinations for nest numbers;\cr
'convolution' [default] uses the exact likelihood of the sum of negative binomial distribution.}

\item{infinite}{Number of iterations for dSnbinom() used for method_incertitude='sum'}

\item{zero_counts}{example c(TRUE, TRUE, FALSE) indicates whether the zeros have 
been recorded for each of these timeseries. Defaut is TRUE for all.}

\item{store.intermediate}{TRUE or FALSE to save the intermediates}

\item{file.intermediate}{Name of the file where to save the intermediates as a list}

\item{parallel}{If FALSE, no parallel computing is done to evaluate likelihood}

\item{hessian}{If FALSE does not estimate se of parameters}

\item{silent}{If TRUE does not show any message}

\item{growlnotify}{If FALSE, does not send growl notification (only in MacOSX)}

\item{cofactors}{data.frame with a column Date and a column for each cofactor}

\item{add.cofactors}{Names of the column of parameter cofactors to use as a cofactor}

\item{zero}{If the theoretical nest number is under this value, this value wll be used}

\item{lower}{Lower bound for each parameter}

\item{upper}{Upper bound for each parameter}

\item{control}{List for control parameters for optim}
}
\value{
Return a list of with data and result
}
\description{
Function of the package phenology to fit parameters to timeseries.\cr
To fit data, the syntaxe is :\cr
Result <- fit_phenology(data=dataset, fitted.parameters=par, fixed.parameters=pfixed, trace=1, method_incertitude=2, zero_counts=TRUE, hessian=TRUE)\cr
or if no parameter is fixed :\cr
Result <- fit_phenology(data=dataset, fitted.parameters=par)\cr
Add trace=1 [default] to have information on the fit progression or trace=0 to hide information on the fit progression.\cr
zero_counts = c(TRUE, TRUE, FALSE) indicates whether the zeros have been recorded for each of these timeseries. Defaut is TRUE for all.\cr
hessian = FALSE does not estimate se of parameters.\cr
If the parameter Theta is fixed to +Inf, a Poissonian model of daily nest distribution is implemented.
}
\details{
fit_phenology fits parameters to timeseries.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
Gratiot <- read.delim("http://max2.ese.u-psud.fr/epc/conservation/BI/Complete.txt", 
header=FALSE)
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name="Complete", 
		reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL)
data(result_Gratiot)
# Plot the phenology and get some stats
output <- plot(result_Gratiot)
# Use fit with co-factor
# First extract tide information for that place
td <- tide.info(year=2001, latitude=4.9167, longitude=-52.3333, tz="America/Cayenne")
td2 <- td[td$Tide=="High Tide", ]
td3 <- cbind(td2, Date=as.Date(td2$Date.Time))
td4 <- td3[(as.POSIXlt(td3$Date.Time)$hou<6) | (as.POSIXlt(td3$Date.Time)$hou>18), ]
with(td4, plot(Date.Time, Level, type="l"))
data_Gratiot$Complete$Date
td5 <- merge(data_Gratiot$Complete, td4, by.x="Date", by.y="Date")
td6 <- td5[, c("Date", "Level")]
parg <- par_init(data_Gratiot, fixed.parameters=NULL, add.cofactors="Level")
result_Gratiot_CF <- fit_phenology(data=data_Gratiot, 
		fitted.parameters=parg, fixed.parameters=NULL, cofactors=td6, 
		add.cofactors="Level")
compare_AIC(WithoutCF=result_Gratiot, WithCF=result_Gratiot_CF)
plot(result_Gratiot_CF)

# Example with two series fitted with different peaks but same Length of season

Gratiot2 <- Gratiot
Gratiot2[, 2] <- floor(Gratiot2[, 2]*runif(n=nrow(Gratiot2)))
data_Gratiot <- add_phenology(Gratiot, name="Complete",
                              reference=as.Date("2001-01-01"), format="\%d/\%m/\%Y")
data_Gratiot <- add_phenology(Gratiot2, name="Complete2",
                              reference=as.Date("2001-01-01"), 
                              format="\%d/\%m/\%Y", previous=data_Gratiot)
pfixed=c(Min=0)
p <- par_init(data_Gratiot, fixed.parameters = pfixed)
p <- c(p, Peak_Complete=175, Peak_Complete2=175)
p <- p[-4]
p <- c(p, Length=90)
p <- p[-(3:4)]
result_Gratiot <- fit_phenology(data=data_Gratiot, fitted.parameters=p, 
fixed.parameters=pfixed)
}
}
\author{
Marc Girondot
}
