% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateCF.R
\name{generateCF}
\alias{generateCF}
\title{Generate a set of data to test Clutch Frequency for marine turtles.}
\usage{
generateCF(
  x = c(mu = 4, sd = 1, p = +Inf, mu_season = 13.8360591186578, sd_season =
    0.17440085345944),
  MeanDaysBetween2Nests = 9.8,
  date0 = as.Date("2020-01-01"),
  n = 1,
  verbose = TRUE
)
}
\arguments{
\item{x}{Initial parameters to be used}

\item{MeanDaysBetween2Nests}{Number of days in average between two nests}

\item{date0}{Initial date to generate data}

\item{n}{Number of individuals to model}

\item{verbose}{If TRUE, give information about each animal.}
}
\value{
Return a list with 4 elements: Category, CF, Beginning and Observations being a 
dataframe of individuals.
}
\description{
This function generates a dataframe to test \code{fitCF()}.\cr
This model is an enhanced version of the one published by Briane et al. (2007).\cr
Parameters are \code{mu} and \code{sd} being the parameters of a  
distribution used to model the clutch frequency.\cr
This distribution is used only as a guide but has not statistical meaning.\cr
The parameter \code{p} is the -logit probability that a female is seen 
on the beach for a particular nesting event. It includes both the probability 
that it is captured but also the probability that it uses that specific beach.\cr
Several categories of females can be included in the model using index after 
the name of the parameter, for example \code{mu1}, \code{sd1} and \code{mu2}, 
\code{sd2} indicates that two categories of females with different clutch 
frequencies distribution are present. Similarly \code{p1} and \code{p2} indicates 
that two categories of females with different capture probabilities are present.\cr
If more than one category is used, then it is necessary to include the 
parameter \code{OTN} to indicate the relative frequencies of each category. 
If two categories are used, one \code{OTN} parameter named \code{ONT1} must 
be included. The \code{OTN2} is forced to be 1. Then the relative frequency 
for category 1 is \code{OTN1/(OTN1+1)} and for category 2 is \code{1/(OTN1+1)}. 
Same logic must be applied for 3 and more categories with always the last one 
being fixed to 1.\cr

if p or a (logit of the capture probability) are equal to -Inf, 
the probability of capture is 0 and if they are equal to 
+Inf, the probability is 1.\cr

The value of p out of the period 
of nesting must be set to +Inf (capture probability=1)
to indicate that no turtle is nesting in this period.\cr

p must be set to -Inf (capture probability=0) to indicate that no
monitoring has been done during a specific period of the nesting season.\cr

The best way to indicate capture probability for 3D model (OCF, ECF, Period) 
is to indicate p.period common for all categories and a1, a2, etc for each category. 
The capture probability for category 1 will be p.period * a1, and for category 2 
will be p.period * a2, etc. \cr

In this case, the parameters p.period should be indicated in fitted parameters 
as well as a1, but a2 must be fixed to +Inf in fixed.parameters. Then the capture 
probability for category 2 will be p.period and for category 1 a1 * p.period.\cr
}
\details{
generateCF generates set of data to test fitCF.
}
\examples{
\dontrun{
library(phenology)
# Example

par <- c(mu = 2.4911638591178051, 
         sd = 0.96855483039640977, 
         mu_season = 13.836059118657793, 
         sd_season = 0.17440085345943984, 
         p.10 = 1.3348233607728222, 
         p.11 = 1.1960387774393837, 
         p.12 = 0.63025680979544774, 
         p.13 = 0.38648155002707452, 
         p.14 = 0.31547864054366048, 
         p.15 = 0.19720001827017075, 
         p.16 = 0.083199496372073328, 
         p.17 = 0.32969130595897905, 
         p.18 = 0.36582777525265819, 
         p.19 = 0.30301248314170637, 
         p.20 = 0.69993987591518514, 
         p.21 = 0.13642423871641118, 
         p.22 = -1.3949268190534629, 
         p=+Inf)

o_mu1p1season1 <- generateCF(x=par, n=1, verbose=TRUE)
o_mu1p1season1 <- generateCF(x=par, n=1000)
plot(o_mu1p1season1$CF)
hist(o_mu1p1season1$Beginning)
}
}
\seealso{
Briane J-P, Rivalan P, Girondot M (2007) The inverse problem applied 
            to the Observed Clutch Frequency of Leatherbacks from Yalimapo beach, 
            French Guiana. Chelonian Conservation and Biology 6:63-69

Fossette S, Kelle L, Girondot M, Goverse E, Hilterman ML, Verhage B, 
         Thoisy B, de, Georges J-Y (2008) The world's largest leatherback 
         rookeries: A review of conservation-oriented research in French 
         Guiana/Suriname and Gabon. Journal of Experimental Marine Biology 
         and Ecology 356:69-82

Other Model of Clutch Frequency: 
\code{\link{ECFOCF_full}()},
\code{\link{ECFOCF_f}()},
\code{\link{TableECFOCF}()},
\code{\link{fitCF_MHmcmc_p}()},
\code{\link{fitCF_MHmcmc}()},
\code{\link{fitCF}()},
\code{\link{lnLCF}()},
\code{\link{logLik.ECFOCF}()},
\code{\link{plot.ECFOCF}()},
\code{\link{plot.TableECFOCF}()}
}
\author{
Marc Girondot
}
\concept{Model of Clutch Frequency}
