% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.phenology.R
\name{plot.phenology}
\alias{plot.phenology}
\title{Plot the phenology from a result.}
\usage{
\method{plot}{phenology}(
  x,
  ...,
  series = "all",
  moon = FALSE,
  replicate.CI = 10000,
  resultmcmc = NULL,
  chain = 1,
  replicate.CI.mcmc = "all",
  level = 0.95,
  plot.objects = c("observations", "ML", "ML.SD", "ML.quantiles", "MCMC.quantiles"),
  col.ML = "black",
  col.SD = "red",
  col.SD.polygon = rgb(red = 1, green = 0, blue = 0, alpha = 0.2),
  col.MCMC.quantiles = "purple",
  col.MCMC.quantiles.polygon = rgb(red = 160/255, green = 32/255, blue = 240/255, alpha =
    0.2),
  col.ML.quantiles = "black",
  col.ML.quantiles.polygon = rgb(red = 0, green = 0, blue = 0, alpha = 0.2),
  col.observations = "black",
  col.grouped.observations = "green"
)
}
\arguments{
\item{x}{A result file generated by fit_phenology}

\item{...}{Parameters used by plot}

\item{series}{Name or number of series to be plotted or 'all'}

\item{moon}{If TRUE, the moon phase is ploted. Default is FALSE}

\item{replicate.CI}{Number of replicates for estimation of confidence interval}

\item{resultmcmc}{A mcmc object}

\item{chain}{The number of chain to be used in resultmcmc}

\item{replicate.CI.mcmc}{Number of iterations to be used or "all"}

\item{level}{Level to estimate confidence interval or credibility interval}

\item{plot.objects}{What to plot?}

\item{col.ML}{Color of the ML mean curve}

\item{col.SD}{Color of the SD curve (distribution of observations)}

\item{col.SD.polygon}{Color of the polygon of the SD curve. If FALSE not shown.}

\item{col.MCMC.quantiles}{Color of the quantiles curve based on mcmc}

\item{col.MCMC.quantiles.polygon}{Color of the credibility interval polygon based on MCMC. If FALSE not shown.}

\item{col.ML.quantiles}{Color of the SE curve based on ML}

\item{col.ML.quantiles.polygon}{Color of the confidence interval polygon based on ML. If FALSE not shown.}

\item{col.observations}{Color of the points}

\item{col.grouped.observations}{Color of the lines indicating grouped observations}
}
\value{
A list with four objects: synthesis is a data.frame with global estimate of nesting.\cr
details_MCMC, details_ML and details_mean are lists with day by day information for each series.
}
\description{
The function plot.phenology plots the phenology graph from a result object.\cr
If cofactors have been added, the plot does not show their effects.\cr
plot.objects can be "observations", "ML" for maximum likelihood, "ML.SD" for dispersion of 
observations, "ML.quantiles" or "MCMC.quantiles" if a mcmc object is given
}
\details{
plot.phenology plots the phenology.
}
\examples{
\dontrun{
library(phenology)
# Read a file with data
data(Gratiot)
# Generate a formatted list nammed data_Gratiot 
data_Gratiot <- add_phenology(Gratiot, name = "Complete", 
		reference = as.Date("2001-01-01"), format="\%d/\%m/\%Y")
# Generate initial points for the optimisation
parg <- par_init(data_Gratiot, fixed.parameters=NULL)
parg <- c('Max_Complete' = 33.076044848500167, 25, 
          'MinB_Complete' = 0.21758630798131923, 
          'MinE_Complete' = 0.42493953463205936, 
          'LengthB' = 96.158007568020523, 
          'Peak' = 174.62435300274245, 
          'LengthE' = 62.084876419654634, 
          'Flat' = 0, 
          'Theta' = 3.5864650991821954)
# Run the optimisation
result_Gratiot <- fit_phenology(data=data_Gratiot, 
		                             fitted.parameters=parg, 
		                             fixed.parameters=NULL)
data(result_Gratiot)
# Plot the phenology and get some stats
output <- plot(result_Gratiot)
# Plot only part of the nesting season
ptoutput <- plot(result_Gratiot, xlim=c(as.Date("2001-03-01"),as.Date("2001-08-31")))
# Use month names in English
Sys.setlocale(category = "LC_TIME", locale = "en_GB.UTF-8")
output <- plot(result_Gratiot)
# set back the month name in local R language
Sys.setlocale(category = "LC_TIME", locale = "")
# plot based on quantiles of mcmc object
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "MCMC.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.SD", "ML.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.SD", "MCMC.quantiles"))
plot(result_Gratiot, resultmcmc=result_Gratiot_mcmc, 
            plot.objects=c("observations", "ML.quantiles", "MCMC.quantiles"))
}
}
\seealso{
Other Phenology model: 
\code{\link{AutoFitPhenology}()},
\code{\link{BE_to_LBLE}()},
\code{\link{Gratiot}},
\code{\link{LBLE_to_BE}()},
\code{\link{LBLE_to_L}()},
\code{\link{L_to_LBLE}()},
\code{\link{MarineTurtles_2002}},
\code{\link{MinBMinE_to_Min}()},
\code{\link{adapt_parameters}()},
\code{\link{add_SE}()},
\code{\link{add_phenology}()},
\code{\link{extract_result}()},
\code{\link{fit_phenology}()},
\code{\link{likelihood_phenology}()},
\code{\link{logLik.phenology}()},
\code{\link{map_Gratiot}},
\code{\link{map_phenology}()},
\code{\link{par_init}()},
\code{\link{phenology2fitRMU}()},
\code{\link{phenology_MHmcmc_p}()},
\code{\link{phenology_MHmcmc}()},
\code{\link{phenology}()},
\code{\link{plot.phenologymap}()},
\code{\link{plot_delta}()},
\code{\link{plot_phi}()},
\code{\link{print.phenologymap}()},
\code{\link{print.phenologyout}()},
\code{\link{print.phenology}()},
\code{\link{remove_site}()},
\code{\link{result_Gratiot1}},
\code{\link{result_Gratiot2}},
\code{\link{result_Gratiot_Flat}},
\code{\link{result_Gratiot_mcmc}},
\code{\link{result_Gratiot}},
\code{\link{summary.phenologymap}()},
\code{\link{summary.phenologyout}()},
\code{\link{summary.phenology}()}
}
\author{
Marc Girondot \email{marc.girondot@gmail.com}
}
\concept{Phenology model}
