% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/binned.kernel.est.R
\name{binned.kernel.est}
\alias{binned.kernel.est}
\title{Kernel Density Estimation}
\usage{
binned.kernel.est(data, kernel = "normal", bandwidth = NULL,
  canonical = FALSE, scalest = "minim", level = 2L,
  gridsize = 401L, range.data = range(data), truncate = TRUE)
}
\arguments{
\item{data}{a numeric vector containing the sample on which the kernel density estimate is to be constructed.}

\item{kernel}{character string specifying the smoothing kernel}

\item{bandwidth}{the kernel bandwidth smoothing parameter.}

\item{canonical}{a logical value indicating whether canonically scaled kernels should be used}

\item{scalest}{estimate of scale. 
\itemize{
 \item \code{"stdev"} - standard deviation is used.
 \item \code{"iqr"} - inter-quartile range divided by 1.349 is used.
 \item \code{"minim"} - minimum of \code{"stdev"} and \code{"iqr"} is used.
}}

\item{level}{number of levels of functional estimation used in the plug-in rule.}

\item{gridsize}{the number of equally-spaced points over which binning is performed to obtain kernel functional approximation.}

\item{range.data}{vector containing the minimum and maximum values of \code{data} at which to compute the estimate. The default is the minimum and maximum data values.}

\item{truncate}{logical value indicating whether data with x values outside the range specified by \code{range.data} should be ignored.}
}
\description{
This function implements an interface to the kernel density estimation functions provided by the \pkg{KernSmooth} package.
}
\references{
Matt Wand (2015). KernSmooth: Functions for Kernel Smoothing Supporting Wand & Jones (1995). R package version 2.23-14.

Henry Deng and Hadley Wickham (2011). Density estimation in R. \url{http://vita.had.co.nz/papers/density-estimation.pdf}.
}
\author{
Hajk-Georg Drost
}
