% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ph.R
\name{ph_fill}
\alias{ph_fill}
\title{Fill SVG icon}
\usage{
ph_fill(icon, colors, breaks, orientation = c("vertical", "horizontal"))
}
\arguments{
\item{icon}{An icon generated with \code{\link[=ph]{ph()}}.}

\item{colors}{Colors to fill icon with.}

\item{breaks}{Breaks where to switch colors.}

\item{orientation}{Orientation of color filling: \code{vertical} (from bottom to top), \code{horizontal} (from left to right).}
}
\value{
An SVG tag.
}
\description{
Fill an SVG icon with different colors according to breaks.
}
\examples{
library(phosphoricons)
ph_fill(
  ph("heart", weight = "fill", height = 128),
  colors = c("#DF0101", "#F6CECE"),
  breaks = 0.7
)

ph_fill(
  ph("star", weight = "fill", height = 128, stroke = "gold", `stroke-width` = 10),
  colors = c("gold", "#FFF"),
  breaks = 0.5,
  orientation = "h"
)


# Multiple colors:
ph_fill(
  ph("trash", weight = "fill", height = 128),
  colors = c("forestgreen", "firebrick", "steelblue", "gold"),
  breaks = c(0.3, 0.6, 0.9)
)

}
