% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-oopi-file.r
\name{read_oo_pidata}
\alias{read_oo_pidata}
\title{Read File Saved by Ocean Optics' Raspberry Pi software.}
\usage{
read_oo_pidata(
  file,
  date = NULL,
  geocode = NULL,
  label = NULL,
  tz = NULL,
  locale = readr::default_locale(),
  npixels = Inf,
  spectrometer.sn = "FLMS00673"
)
}
\arguments{
\item{file}{character string}

\item{date}{a \code{POSIXct} object to use to set the \code{"when.measured"}
attribute. If \code{NULL}, the default, the date is set to the file
modification date.}

\item{geocode}{A data frame with columns \code{lon} and \code{lat} used to
set attribute \code{"where.measured"}.}

\item{label}{character string, but if \code{NULL} the value of \code{file} is
used, and if \code{NA} the "what.measured" attribute is not set.}

\item{tz}{character Time zone is not saved to the file.}

\item{locale}{The locale controls defaults that vary from place to place. The
default locale is US-centric (like R), but you can use
\code{\link[readr]{locale}} to create your own locale that controls things
like the default time zone, encoding, decimal mark, big mark, and day/month
names.}

\item{npixels}{integer Number of pixels in spectral data.}

\item{spectrometer.sn}{character The serial number of the spectrometer needs
to be supplied by the user as it is not included in the file header.}
}
\value{
A raw_spct object.
}
\description{
Reads and parses the header of a raw data file as output by the server
running on a Raspberry Pi board to extract the whole header remark field. The
time field is retrieved and decoded. 
The company formerly named Ocean Optics is now called Ocean Insight.
}
\note{
The header in these files has very little information.
The file contains a time in milliseconds but as the Raspberry Pi board
contains no real-time clock, it seems to default to number of milliseconds
since the Pi was switched on. The user may wish to supply the date-time as
an argument, but if no argument is passed to \code{date} this
attribute is set to the file modification date obtained with \code{file.mtime()}.
This date-time gives an upper limit to the real time of measurement as in
some operating systems it is reset when the file is copied or even without
any good apparent reason. The user may need to supply the number of pixels 
in the array although the default of \code{npixels = Inf} usually works
and triggers no warnings.
}
\examples{

 file.name <- 
   system.file("extdata", "spectrum.pi", 
               package = "photobiologyInOut", mustWork = TRUE)
                
 oopi.spct <- read_oo_pidata(file = file.name)
 
 oopi.spct
 getWhenMeasured(oopi.spct)
 getWhatMeasured(oopi.spct)
 cat(comment(oopi.spct))

}
\references{
\url{https://www.oceaninsight.com/} \url{https://www.raspberrypi.org/}
}
