% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fdata-conversion.R
\name{mspct2fdata}
\alias{mspct2fdata}
\alias{spct2fdata}
\alias{fdata2spct}
\alias{fdata2mspct}
\title{Convert spectra into 'fda.usc::fdata' objects}
\usage{
mspct2fdata(x, spct.data.var = NULL, multiplier = 1, ...)

spct2fdata(x, spct.data.var = NULL, multiplier = 1, ...)

fdata2spct(x, multiplier = 1, member.class = NULL, drop.idx = FALSE, ...)

fdata2mspct(x, multiplier = 1, member.class = NULL, drop.idx = FALSE, ...)
}
\arguments{
\item{x}{generic_mspct or generic_spct object or an object belonging to a
derived class, or an object of class 'fdata' depending on the function.}

\item{spct.data.var}{character The name of the column containing data to
export. If \code{NULL} the first spectral data column found is used.}

\item{multiplier}{numeric A multiplier to be applied to the 'spc' data to do
unit or scale conversion.}

\item{...}{possibly additional named arguments passed to object constructors.}

\item{member.class}{character Name of the class of the spectrum or of the
members of the collection of spectra.}

\item{drop.idx}{logical Flag indicating whether to drop or keep
\code{idx.var} in the collection members.}
}
\description{
Convert spectral objects (xxxx_spct, xxxx_mspct) as defined in package
'photobiology' into \code{fda.usc::fdata} objects, preserving as much
information as possible. As \code{fdata} objects can contain other kinds
of data, the reverse conversion is supported (experimentally) and mainly
for 'fdata' objects returned by the functional data analysis methods from
package \code{fda.usc} to spectral data previosuly exported in the
opposite direction.
}
\section{Warning!}{
 When converting multiple spectra, all the spectra to be
included in the \code{fdata} object must share the same wavelength values.
Spectra that do not fulfil this condition will be skipped. The data variable
needs also to be present in all individual spectra as no conversions are 
applied automatically by this function. If a different name, indicating a
different quantity or a different base of expression is encountered, the
affected spectrum is skipped with a warning.
}

\examples{
if (requireNamespace("fda.usc", quietly = TRUE)) {
# from spectra to fdata
  sun.fdata <- spct2fdata(sun.spct)
  str(sun.fdata)
  polyester.fdata <- spct2fdata(polyester.spct)
  str(polyester.fdata)
# from fdata to spectra
  fdata2spct(sun.fdata)
  fdata2spct(sun.fdata, drop.idx = TRUE)
  fdata2spct(polyester.fdata, drop.idx = TRUE)
}

}
