% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read-cie-csv.r
\name{read_CIE_csv}
\alias{read_CIE_csv}
\title{Read '.CSV' files from CIE}
\usage{
read_CIE_csv(file.name, label = NULL, simplify = FALSE)
}
\arguments{
\item{file.name}{character string Name of CSV file.}

\item{label}{character string. If \code{NULL} metadata read from the
JSON file is used, and if \code{NA} the \code{"what.measured"} attribute 
is not set, and if a character string is passed, it is used to set 
the \code{"what.measured"} attribute.}

\item{simplify}{logical If \code{TRUE} and the read file contained a single
spectrum, extract the spectral object from the collection.}
}
\value{
Depending on the contents of the file, a \code{source_mspct} or
  \code{source_spct} object, a \code{response_spct} or \code{response_spct}
  object, or a \code{chroma_spct} object, containing both data and metadata.
  The whole metadata JSON converted into an R `list` is stored in attribute
  "header".
}
\description{
Reads a CSV spectral data file and its companion JSON file with metadata as
published by \emph{International Commission on Illumination} (CIE) and then 
imports wavelengths and spectral values into one the classes for spectral
data defined in package 'photobiology.
}
\details{
The CSV file contains only numbers encoded as character strings, and the
JSON file contains extensive metadata. The type of spectral data is encoded
as part of the file name. If the original file name of the CSV file is passed
as argument to parameter \code{file}, the function can retrieve all data and
metadata, enough to return an R object of the correct class. The JSON file
must be located in the same folder as the CSV file.
}
\examples{

file.name <- 
  system.file("extdata", "CIE_illum_C.csv", 
              package = "photobiologyInOut", mustWork = TRUE)

CIE_illum_C.spct <- read_CIE_csv(file.name)
CIE_illum_C.spct
   
file.name <- 
  system.file("extdata", "CIE_sle_photopic.csv", 
              package = "photobiologyInOut", mustWork = TRUE)

CIE_sle_photopic.spct <- read_CIE_csv(file.name)
CIE_sle_photopic.spct
   
}
\references{
\url{https://cie.co.at/data-tables}
}
\keyword{misc}
