#' Spectral data for lamps supplied by Osram
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Osram. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' osram_lamps
#' 
#' @references \url{https://www.osram.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"osram_lamps"

#' Spectral data for lamps supplied by Philips
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Osram. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' philips_lamps
#' 
#' @references \url{http://www.lighting.philips.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"philips_lamps"

#' Spectral data for lamps supplied by Sylvania
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Osram. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' sylvania_lamps
#' 
#' @references \url{https://www.sylvania.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"sylvania_lamps"

#' Spectral data for lamps supplied by Q-LAB
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps branded Q-Panel and supplied by Q-LAB. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' qpanel_lamps
#' 
#' @references \url{http://www.q-lab.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"qpanel_lamps"

#' Spectral data for lamps supplied by Airam
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Airam Electric Oy Ab. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' osram_lamps
#' 
#' @references \url{https://www.airam.fi/en/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"airam_lamps"

#' Spectral data for lamps supplied by Toshiba
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Toshiba. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' toshiba_lamps
#' 
#' @references \url{https://www.uot-toshibalighting.eu/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"toshiba_lamps"

#' Spectral data for lamps supplied by Aputure
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for photography and video lamps from Aputure. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' aputure_lamps
#' 
#' @references \url{https://www.aputure.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"aputure_lamps"

#' Spectral data for lamps supplied by Sunwayfoto
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for photography and video lamps from Sunwayfoto 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' sunwayfoto_lamps
#' 
#' @references \url{https://www.aputure.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"sunwayfoto_lamps"

#' Spectral data for lamps supplied by Godox
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for photography lamps and flashes from Godox 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' godox_lamps
#' 
#' @references \url{https://www.aputure.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"godox_lamps"

#' Spectral data for lamps supplied by Valoya
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for plant grow lamps from Valoya Oy (Finland).
#' Data measured by the author are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' valoya_lamps
#' 
#' @references \url{https://www.valoya.com/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"valoya_lamps"

#' Spectral data for lamps supplied by Osram-Fluence
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for plant grow lamps from Fluence (Osram).
#' Data digitized from manufacturer's brochure are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' fluence_lamps
#' 
#' @references \url{https://fluence.science/}
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"fluence_lamps"

#' Spectral data for shop-branded lamps 
#' 
#' Names of datasets containing the wavelengths and tabulated values spectral emittance 
#' for lamps from Toshiba. 
#' Data are normalized to one at the wavelength of maximum emission.
#' 
#' @docType data
#' @keywords datasets
#' @format A vector of character strings.
#' 
#' @examples 
#' generic_lamps
#' 
#' @seealso \code{\link{lamps.mspct}}
#' 
#' @family manufacturers
#' 
"generic_lamps"
