% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phreeqc.R
\docType{data}
\name{ex9}
\alias{ex9}
\title{Example 9--Kinetic Oxidation of Dissolved Ferrous Iron With Oxygen}
\source{
\url{https://www.usgs.gov/software/phreeqc-version-3/}
}
\description{
Kinetic rate expressions can be defined in a completely general
way in PHREEQC by using Basic statements in the RATES data block. The rate
expressions can be used in batch-reaction and transport calculations with
the KINETICS data block. For transport calculations (ADVECTION or TRANSPORT),
kinetic reactions can be defined cell by cell by the number range following
the KINETICS keyword (KINETICS m-n). The rate expressions are integrated with
an embedded (up to) 5th-order Runge-Kutta-Fehlberg algorithm, or with a
stiff, variable-order, variable-step multistep solver (Cohen and Hindmarsh,
1996). Equilibrium is calculated before a kinetic calculation is initiated
and again when a kinetic reaction increment is added. Equilibrium includes
solution species equilibrium; exchange-, equilibrium-phase-, solid-solution-,
and surface-assemblage equilibrium; and gas-phase equilibrium. A check is
performed to ensure that the difference between estimates of the integrated
rate over a time interval is smaller than a user-defined tolerance. If the
tolerance is not satisfied, then the integration over the time interval is
automatically restarted with a smaller time interval. The example can be run
using the \code{\link{phrRunString}} routine.
}
\examples{

phrLoadDatabaseString(phreeqc.dat)
phrSetOutputStringsOn(TRUE)
phrRunString(ex9)
phrGetOutputStrings()

}
\references{
\url{https://pubs.usgs.gov/tm/06/a43/pdf/tm6-A43.pdf}
}
\seealso{
Other Examples: 
\code{\link{ex1}},
\code{\link{ex10}},
\code{\link{ex11}},
\code{\link{ex12}},
\code{\link{ex13a}},
\code{\link{ex14}},
\code{\link{ex15}},
\code{\link{ex16}},
\code{\link{ex17}},
\code{\link{ex18}},
\code{\link{ex19}},
\code{\link{ex2}},
\code{\link{ex20a}},
\code{\link{ex21}},
\code{\link{ex22}},
\code{\link{ex3}},
\code{\link{ex4}},
\code{\link{ex5}},
\code{\link{ex6}},
\code{\link{ex7}},
\code{\link{ex8}}
}
\concept{Examples}
\keyword{dataset}
